set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6604658';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-6-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '400',
      '10204034',
      70,
      45.148157,
      '0314240',
      35.889197,
      1,
      1.143049,
      NULL,
      '434101',
      NULL,
      ' 7-22-2001',
      65,
      107.669438,
      NULL,
      NULL,
      0.799833,
      2,
      NULL,
      NULL,
      1,
      1.573714,
      3,
      3.360950,
      NULL,
      0.398695,
      0,
      0,
      1.704592,
      0.738686,
      NULL,
      NULL,
      NULL,
      0.968730,
      3.501136,
      0.699092,
      0.680326,
      1.331809,
      3,
      0,
      1,
      3,
      0,
      0.805710,
      NULL,
      NULL,
      1.754156,
      NULL,
      NULL,
      1,
      1,
      0.644345,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.514376,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.544202,
      0.412358,
      1,
      0.545696,
      1,
      0.574631,
      1,
      1,
      0.294212,
      0,
      1,
      NULL,
      1.391569,
      NULL,
      1.706565,
      0,
      1,
      NULL,
      1,
      1,
      3,
      NULL,
      3,
      3,
      5.269182,
      1.969432,
      2,
      2.368853,
      NULL,
      3,
      2,
      1,
      2.465559,
      NULL,
      NULL,
      5.791064,
      6.812868,
      1,
      1.006824,
      3,
      0,
      3.919974,
      2,
      1,
      3,
      4,
      1.420919,
      1.904209,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.055490,
      1,
      NULL,
      0,
      1.311628,
      1.135017,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.182139,
      NULL,
      3.574643,
      2.161746,
      3.681086,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.175490,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3.251970,
      1,
      NULL,
      3.991190,
      NULL,
      NULL,
      0.995375,
      NULL,
      NULL,
      NULL,
      1,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.401736,
      2.177835,
      NULL,
      1,
      2.989161,
      3,
      2,
      1,
      1,
      2,
      0,
      0.652056,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.758108,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      2,
      NULL,
      0.734448,
      5,
      NULL,
      4,
      2,
      3,
      3);
commit;
end;
/


