set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6604658';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-2-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '001',
      '31044443',
      19,
      80,
      '4300142',
      NULL,
      3,
      1,
      0,
      '300321',
      2,
      ' 9-14-1983',
      51.060516,
      30.191799,
      0,
      NULL,
      0,
      0,
      NULL,
      0.981585,
      0,
      1.299266,
      0.413426,
      NULL,
      NULL,
      1,
      9.743250,
      NULL,
      1,
      1,
      0.338301,
      NULL,
      0.314858,
      1.169793,
      1.757537,
      1.920300,
      1,
      1.764780,
      NULL,
      1,
      2,
      2.988905,
      0.822189,
      0,
      NULL,
      NULL,
      1.327178,
      NULL,
      NULL,
      0.752217,
      6.685213,
      0,
      3,
      0.342129,
      1.289967,
      0,
      NULL,
      NULL,
      1.434652,
      0.413004,
      2.392061,
      0.456742,
      0,
      NULL,
      0,
      1.544407,
      0,
      0,
      1.628424,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.723034,
      NULL,
      NULL,
      NULL,
      1.318569,
      1,
      1,
      NULL,
      0.484158,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.609520,
      0,
      0.581672,
      0.511759,
      NULL,
      0.830487,
      0,
      1,
      NULL,
      1,
      4.598320,
      5,
      6.975402,
      4,
      1.284392,
      6.332007,
      1.354065,
      NULL,
      4,
      5.613477,
      2,
      6.788918,
      7.876927,
      NULL,
      1,
      4,
      7,
      NULL,
      7,
      3.014678,
      8.713456,
      5.704444,
      3.230109,
      0,
      2.963822,
      3.678353,
      NULL,
      2.751904,
      1.651027,
      1.370817,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.466354,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      1.338494,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.452663,
      NULL,
      9,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.004676,
      2.590963,
      0.418742,
      NULL,
      NULL,
      NULL,
      5,
      0,
      8,
      3,
      3.336065,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.154568,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.179986,
      0.242153,
      0,
      NULL,
      0.485351,
      2.417820,
      0.983930,
      3.374129,
      2.524676,
      1,
      NULL,
      0,
      1,
      0,
      0.930645,
      1.841644,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.831401,
      '40301',
      NULL,
      NULL,
      1.348688,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      3,
      NULL,
      NULL,
      2,
      NULL,
      3.927007,
      2,
      2,
      2);
commit;
end;
/


