set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6604658';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-8-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '41020034',
      44,
      54.894950,
      '4334013',
      NULL,
      6,
      NULL,
      2,
      '400024',
      0.225658,
      NULL,
      49.759984,
      NULL,
      0,
      NULL,
      0.462858,
      3.469687,
      0,
      NULL,
      1.219488,
      1.639804,
      0,
      3,
      1.274626,
      0.407658,
      7.952225,
      1.785443,
      2,
      0.272548,
      0,
      NULL,
      4,
      0.005174,
      NULL,
      1,
      4,
      0,
      5.873924,
      NULL,
      NULL,
      1.535250,
      0,
      1.629792,
      NULL,
      NULL,
      1.655495,
      NULL,
      NULL,
      NULL,
      NULL,
      0.777303,
      1.854084,
      0,
      0.684238,
      3.620815,
      1,
      1,
      1.268572,
      3,
      2.674681,
      2.078454,
      0.987979,
      1.962302,
      NULL,
      0,
      1,
      0,
      0.343634,
      1.445954,
      1,
      5.628797,
      0,
      0,
      3.735091,
      NULL,
      NULL,
      NULL,
      1.804072,
      NULL,
      NULL,
      1.968497,
      NULL,
      1.541010,
      0.064166,
      NULL,
      1,
      0,
      0.521492,
      1,
      1.226777,
      0,
      1.805542,
      0.071207,
      1.621716,
      1.606755,
      0.975153,
      1,
      0.554051,
      0.609620,
      NULL,
      1,
      NULL,
      3,
      3.781251,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.586944,
      0,
      0,
      0.781278,
      1.473915,
      7.101857,
      1.134192,
      0.516399,
      NULL,
      9,
      1,
      6.861629,
      5.181370,
      3,
      NULL,
      3.164666,
      1,
      7,
      NULL,
      0.386401,
      0.777799,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1,
      1,
      1.269344,
      1.347971,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.920001,
      NULL,
      2,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.674301,
      6.384149,
      0,
      5.593267,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.570505,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.433846,
      2,
      NULL,
      NULL,
      1,
      3,
      1.567590,
      1.467461,
      1,
      1.500876,
      1,
      0.504553,
      1,
      0.967593,
      NULL,
      0,
      1.347630,
      1,
      1.197238,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.594534,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      '',
      NULL,
      1.637604,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '',
      NULL,
      1,
      NULL,
      1,
      0.800157,
      0.282607,
      3,
      0,
      NULL);
commit;
end;
/


