set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6604658';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-2-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '22344131',
      36.672304,
      23,
      '0320440',
      NULL,
      6,
      2,
      2,
      '324032',
      4,
      ' 3- 6-1984',
      49,
      NULL,
      0,
      NULL,
      NULL,
      1.970773,
      NULL,
      0,
      NULL,
      0.707683,
      NULL,
      0,
      0,
      1,
      6.963030,
      NULL,
      NULL,
      NULL,
      0,
      1.002824,
      3.985393,
      1,
      2.186299,
      1,
      0,
      0,
      4,
      NULL,
      4,
      NULL,
      0,
      0.265277,
      NULL,
      NULL,
      0.113306,
      NULL,
      NULL,
      1.272151,
      0.855201,
      0.295804,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.233025,
      1.696564,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.557061,
      1,
      NULL,
      0.071065,
      NULL,
      0,
      1,
      1,
      1.419721,
      NULL,
      0.038131,
      0.518160,
      0.546433,
      0.762078,
      0,
      0.890125,
      0,
      1,
      NULL,
      NULL,
      2.374228,
      0.802241,
      2.284130,
      3.066413,
      0,
      0.010502,
      1.156450,
      5,
      1.928402,
      4.671542,
      1.501471,
      1,
      1,
      2,
      0,
      1,
      3.437063,
      6,
      NULL,
      5,
      NULL,
      4.408128,
      NULL,
      5.854448,
      NULL,
      1.916244,
      0,
      1,
      0,
      1.498480,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.102795,
      0,
      1,
      0.184142,
      1.399505,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.992076,
      NULL,
      1.310606,
      2.876976,
      3.895295,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      0.208202,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      0,
      NULL,
      0.018474,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      3.412918,
      1,
      0.294082,
      2.824422,
      1.441820,
      NULL,
      0,
      1.378333,
      1,
      0,
      0,
      1,
      1,
      NULL,
      0.921135,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.271710,
      '10200',
      '',
      '',
      0,
      '',
      '',
      '',
      1.548935,
      '',
      NULL,
      '',
      2,
      1,
      3,
      3,
      0.855530,
      0,
      3,
      1,
      3);
commit;
end;
/


