set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7715855';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-3-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '3',
      NULL,
      NULL,
      '2223002',
      6,
      NULL,
      3.988233,
      1,
      '013001',
      NULL,
      ' 1- 8-2001',
      55,
      NULL,
      1.556097,
      NULL,
      1.542954,
      NULL,
      1,
      1,
      0.801843,
      1.763787,
      1.254695,
      0.704370,
      NULL,
      0,
      0.444893,
      2.698204,
      NULL,
      1,
      1,
      1.833792,
      NULL,
      1,
      NULL,
      1.671920,
      NULL,
      1,
      5.215143,
      0,
      NULL,
      NULL,
      2.165892,
      1.523269,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7,
      0,
      NULL,
      3.955812,
      1.417035,
      NULL,
      NULL,
      2,
      2,
      2,
      0,
      2.130338,
      1.529602,
      3.906634,
      NULL,
      NULL,
      NULL,
      1,
      0,
      4.434154,
      NULL,
      1,
      2,
      1,
      0,
      2.388065,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.121039,
      1,
      NULL,
      1,
      5.664614,
      1,
      0.934415,
      1.502665,
      NULL,
      0,
      NULL,
      1.952490,
      1.313088,
      0.008638,
      NULL,
      0.873497,
      1,
      0.671841,
      1.432945,
      NULL,
      1,
      0,
      1,
      1,
      1.029125,
      NULL,
      0.730838,
      1.135709,
      NULL,
      0,
      1.173507,
      0,
      NULL,
      0.178779,
      NULL,
      0.366072,
      1.398623,
      0,
      0.375204,
      6,
      3,
      NULL,
      2,
      0,
      9,
      0.506609,
      3.107435,
      NULL,
      1,
      0.260421,
      1,
      9,
      0.464330,
      NULL,
      NULL,
      0,
      1.949978,
      1,
      2,
      3.333459,
      2,
      0,
      0,
      3,
      0.946852,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.334163,
      NULL,
      0.930039,
      0.130030,
      0,
      4.248745,
      3.420195,
      3,
      1,
      1.797692,
      1.563677,
      6,
      NULL,
      3.121080,
      1,
      NULL,
      1.636889,
      5,
      1,
      3.161467,
      0.544374,
      NULL,
      NULL,
      4.160970,
      1.917355,
      NULL,
      NULL,
      0,
      11.222247,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.104898,
      3.401082,
      3.373003,
      1.342142,
      1,
      0.584591,
      NULL,
      NULL,
      1,
      NULL,
      1.303931,
      NULL,
      1,
      NULL,
      0,
      1.673063,
      1.233982,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.005135,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '41342',
      '21223',
      '42444',
      1,
      '42204',
      '',
      '',
      0.389324,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


