set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7715855';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-5-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '3',
      NULL,
      NULL,
      NULL,
      9,
      6,
      0.712174,
      0,
      '023302',
      0,
      ' 2-25-2000',
      45,
      NULL,
      0,
      NULL,
      4,
      0,
      0.094713,
      NULL,
      0,
      1,
      NULL,
      0.293849,
      0.043516,
      0.120643,
      1,
      3.327640,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      6.566726,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.669214,
      0.210756,
      3,
      NULL,
      NULL,
      NULL,
      1.746235,
      NULL,
      NULL,
      10,
      NULL,
      5,
      2.996643,
      0.793651,
      0.710939,
      NULL,
      2.741849,
      3.565747,
      0.239564,
      3.091116,
      0.443918,
      2,
      NULL,
      1,
      NULL,
      1,
      1.070809,
      1,
      2,
      5.572379,
      4.959467,
      0,
      NULL,
      2,
      0,
      0.956509,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.647572,
      1,
      0,
      0.480242,
      3,
      1.175892,
      0,
      1.960972,
      1.939544,
      0.771987,
      NULL,
      1.803492,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.217057,
      1.383732,
      NULL,
      1.231369,
      NULL,
      0,
      0,
      1.776379,
      NULL,
      1,
      1,
      2,
      0,
      NULL,
      NULL,
      1.286252,
      0,
      3,
      NULL,
      0,
      9.166175,
      1.786335,
      0.938021,
      3,
      3,
      0,
      5,
      6.503616,
      2,
      5.430903,
      5,
      1,
      1.932047,
      0.794173,
      4,
      0.581451,
      3,
      NULL,
      3,
      1.623572,
      NULL,
      2,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.102310,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0.978427,
      2.086209,
      1.808691,
      3,
      1.177145,
      3.389274,
      0,
      0,
      0,
      NULL,
      0,
      1.446073,
      0,
      NULL,
      1.211836,
      6.481620,
      0,
      6,
      0.474210,
      NULL,
      1,
      1,
      1.718683,
      NULL,
      NULL,
      0,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.060894,
      1,
      0.973278,
      3,
      2,
      1,
      0,
      NULL,
      0.421485,
      1.797084,
      NULL,
      1.521577,
      1,
      0.260502,
      1.240789,
      0,
      NULL,
      0,
      0.622594,
      0.094311,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.339879,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      7.072369,
      '01304',
      '14042',
      '13211',
      NULL,
      '44113',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


