set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8524572';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-6-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '1',
      NULL,
      NULL,
      '0411401',
      7,
      4,
      NULL,
      NULL,
      '114113',
      3.971144,
      ' 9- 5-1978',
      8.037511,
      NULL,
      NULL,
      NULL,
      NULL,
      0.479297,
      2,
      0,
      0.974314,
      NULL,
      0.211793,
      NULL,
      0,
      NULL,
      3,
      0.404598,
      0,
      0,
      0.431128,
      0.823273,
      1.199736,
      1,
      NULL,
      1,
      1,
      NULL,
      1.087300,
      0,
      0,
      1.319742,
      0,
      0.895567,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.822358,
      0.850352,
      1.178758,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.128110,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.150800,
      0.151981,
      0.581475,
      1.566072,
      0,
      1,
      0.835770,
      NULL,
      0,
      0,
      1,
      1,
      1,
      1.119832,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.571054,
      2,
      1,
      NULL,
      NULL,
      1.028643,
      1,
      NULL,
      0.895655,
      NULL,
      NULL,
      NULL,
      4,
      1.913386,
      4.406451,
      1,
      NULL,
      3.754395,
      1.148229,
      0,
      NULL,
      1,
      1,
      6,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      5.658987,
      1.659245,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      0,
      0,
      0.608576,
      1.570430,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.615220,
      NULL,
      1,
      NULL,
      1,
      1.726924,
      0,
      1158.890465,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2.163190,
      1,
      2.848552,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.116698,
      0.909303,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.653406,
      0,
      3,
      1.663576,
      1,
      1.914321,
      NULL,
      2.756364,
      1,
      1,
      1,
      1.414518,
      0,
      0.793023,
      1.835556,
      0,
      NULL,
      0,
      0,
      1.970035,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.029822,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      '',
      NULL,
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


