set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5715854';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-11-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '200',
      NULL,
      27.630301,
      21,
      '0214134',
      8,
      3,
      3.858739,
      NULL,
      '002142',
      NULL,
      ' 1- 1-1978',
      33,
      45,
      0.083725,
      NULL,
      1,
      NULL,
      2.316809,
      0,
      0,
      1.524238,
      1,
      2.589017,
      1,
      1,
      1.092472,
      0.388328,
      1,
      0,
      1,
      4.624613,
      2,
      9.926606,
      1,
      3,
      1.180980,
      1.446360,
      0.711751,
      NULL,
      2.000491,
      3.755433,
      0,
      NULL,
      NULL,
      NULL,
      0.303729,
      NULL,
      NULL,
      10.380469,
      2,
      0.190718,
      NULL,
      NULL,
      1.835929,
      0.477810,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      3.436337,
      1,
      NULL,
      3.818898,
      NULL,
      3.291305,
      5,
      1.268109,
      0.000853,
      2.623421,
      0,
      0,
      3.023713,
      NULL,
      NULL,
      NULL,
      1.360924,
      NULL,
      NULL,
      NULL,
      1.423670,
      0,
      0.771186,
      1,
      NULL,
      2,
      0.337526,
      0,
      1.463344,
      NULL,
      1,
      1,
      1,
      1,
      1,
      1,
      0,
      1.785771,
      NULL,
      1.971570,
      0.318574,
      1.476794,
      0,
      1.294002,
      0.567032,
      1,
      2.637145,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      0.255803,
      0.516783,
      2.640772,
      0.657186,
      NULL,
      5,
      6.617742,
      1,
      NULL,
      2.262145,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.636957,
      0,
      NULL,
      1.310575,
      0.678039,
      1.541498,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.576585,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.704375,
      0.843610,
      0.377776,
      0.925902,
      2.852739,
      4,
      0,
      NULL,
      1.010098,
      0.805277,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.245835,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.948501,
      0.459546,
      NULL,
      NULL,
      2,
      NULL,
      0,
      0,
      0,
      0.689207,
      NULL,
      0,
      0,
      1,
      0,
      0,
      1,
      0.586823,
      1.003428,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.377857,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '43014',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      1.571418,
      '',
      '',
      '',
      4.938227,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


