set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5715854';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-7-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '22',
      10.550260,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      '001442',
      1,
      '10-20-1982',
      24,
      32,
      1.304468,
      NULL,
      1,
      1.969092,
      3,
      0,
      NULL,
      1,
      NULL,
      1.429037,
      0.028590,
      NULL,
      2,
      NULL,
      0,
      0.261633,
      0,
      NULL,
      NULL,
      4.282258,
      0.414903,
      1.705198,
      0.874162,
      0,
      3,
      1,
      NULL,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.855251,
      7.932218,
      0,
      1.355881,
      1,
      NULL,
      0.805977,
      NULL,
      1,
      2.300016,
      3.700585,
      1.615985,
      1,
      NULL,
      1.750209,
      2.320754,
      2,
      NULL,
      2,
      4.120010,
      0.557602,
      1.760435,
      9.335309,
      0,
      NULL,
      NULL,
      0.213897,
      NULL,
      NULL,
      0.181389,
      NULL,
      NULL,
      1,
      0.645827,
      0.361289,
      0,
      0,
      1,
      0.740698,
      1.295162,
      0,
      2.002478,
      3.562803,
      NULL,
      1,
      2,
      0.838992,
      1,
      1,
      0,
      1.261392,
      NULL,
      1.111540,
      0,
      1.652900,
      1.887154,
      1.884697,
      1.910626,
      1.257466,
      0.362649,
      NULL,
      NULL,
      NULL,
      NULL,
      1.171400,
      1.869317,
      NULL,
      0,
      2.308865,
      1.985590,
      NULL,
      0.589454,
      4.557407,
      10.633849,
      5.905672,
      NULL,
      9.333478,
      1.466244,
      NULL,
      NULL,
      1,
      0,
      1.406411,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.119641,
      NULL,
      NULL,
      0.139380,
      0.457484,
      0,
      0.743363,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.030581,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.392914,
      1.001437,
      2,
      1,
      3,
      1.022988,
      1,
      0,
      8,
      2,
      1.067865,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.691210,
      0.671871,
      0,
      3,
      2,
      NULL,
      1,
      0,
      0,
      2.786982,
      0,
      1.592051,
      1.205909,
      1,
      1.117085,
      1.522010,
      NULL,
      1,
      1.037966,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.990394,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.630667,
      '12411',
      '',
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      NULL,
      0.871208,
      2.612860,
      0.676342,
      1,
      NULL,
      NULL,
      1.333299,
      NULL);
commit;
end;
/


