set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6909717';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-7-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '322',
      '44133131',
      72.752755,
      40,
      '0230034',
      9,
      3,
      3,
      1,
      '103002',
      4.901850,
      ' 3-21-1977',
      60.719557,
      25.815121,
      1,
      NULL,
      1.402718,
      1.703386,
      3.778043,
      0,
      0,
      1.734419,
      NULL,
      2.635191,
      1,
      1,
      1.985208,
      NULL,
      1.307327,
      0.958879,
      1,
      1.006679,
      0,
      0,
      1.036749,
      1,
      1,
      0,
      1.846962,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.914618,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.084583,
      NULL,
      0.538367,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.177040,
      1,
      1,
      1,
      0.551658,
      NULL,
      1,
      NULL,
      1,
      0,
      1.844784,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      1.548133,
      NULL,
      1.349346,
      1.917142,
      NULL,
      1.232199,
      0,
      0,
      1.038871,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.878050,
      5,
      1,
      0,
      5,
      3.050412,
      NULL,
      2,
      1,
      NULL,
      2.208662,
      4,
      3.653814,
      1.006483,
      1.649104,
      0,
      0.805967,
      NULL,
      NULL,
      5.390147,
      0.262336,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.127250,
      1.443479,
      1,
      0,
      1,
      0,
      0,
      1.731384,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.874785,
      3.404520,
      NULL,
      6.673991,
      1.186312,
      NULL,
      0.416958,
      NULL,
      NULL,
      NULL,
      0,
      5,
      1.775056,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.187606,
      1.461451,
      NULL,
      1,
      0,
      2.866212,
      3.880103,
      0,
      NULL,
      3,
      0.944893,
      NULL,
      1.857750,
      0.335190,
      0.498957,
      0,
      1.420094,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.424706,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.422055,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.475948,
      NULL,
      1.089078,
      0.620362,
      1,
      1,
      1,
      '44343',
      '31204',
      '',
      0.789356,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '',
      4.956732,
      NULL,
      2.856919,
      NULL,
      1.614658,
      3.729742,
      2.845833,
      5,
      0.928952);
commit;
end;
/


