set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6909717';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-12-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '241',
      NULL,
      71.394252,
      43,
      '2202331',
      13,
      2,
      NULL,
      2,
      '304344',
      1,
      NULL,
      20,
      5,
      0.892819,
      NULL,
      1,
      3,
      0.876134,
      1,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      1.498752,
      1.088344,
      1.504601,
      0.404949,
      0.048468,
      0.080904,
      1.532076,
      0.183291,
      1,
      0.962036,
      NULL,
      1.452030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.755946,
      1.270896,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.711004,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.906199,
      NULL,
      1,
      0.413468,
      NULL,
      NULL,
      0,
      1.862678,
      1,
      NULL,
      0,
      1.241518,
      0,
      NULL,
      0.425067,
      1,
      0.687327,
      1.004034,
      NULL,
      0,
      NULL,
      0.425656,
      1,
      5.118409,
      1.713647,
      NULL,
      1,
      4,
      2.238733,
      0,
      3,
      NULL,
      1.211564,
      4.741273,
      1.592187,
      2.730472,
      5.333513,
      2,
      1,
      4,
      7,
      3,
      4,
      NULL,
      2.061603,
      3,
      0,
      1.227882,
      NULL,
      NULL,
      5,
      0.147537,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.504409,
      0.149992,
      NULL,
      0,
      1,
      1.958449,
      1.300262,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      2,
      1.507609,
      3.141246,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.354326,
      0,
      NULL,
      NULL,
      2.956400,
      4.403937,
      0,
      7.200994,
      5,
      NULL,
      NULL,
      0,
      NULL,
      2.471110,
      NULL,
      NULL,
      7,
      3.718499,
      1.452652,
      3,
      2.046209,
      5,
      0,
      5.327809,
      0.882770,
      NULL,
      0.645629,
      1.577569,
      2.628178,
      NULL,
      NULL,
      3.660968,
      0.766776,
      3.707168,
      2.710463,
      1,
      0.390726,
      0,
      NULL,
      1.629357,
      1.929721,
      1.768769,
      1,
      3,
      0,
      1.893444,
      1.537901,
      0.903895,
      0,
      1.158061,
      1.476067,
      0.904199,
      0.624075,
      0,
      1,
      0.720166,
      NULL,
      NULL,
      2,
      0,
      1.101055,
      0.217083,
      0.113100,
      0,
      1,
      NULL,
      1.120368,
      1.635042,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.625269,
      NULL,
      NULL,
      NULL,
      NULL,
      2.871183,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.565128,
      2,
      NULL,
      NULL,
      '11122',
      '',
      0.675170,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      2,
      NULL,
      2,
      1.556564,
      NULL,
      NULL,
      0);
commit;
end;
/


