set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6909717';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-8-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '20441300',
      19,
      NULL,
      '4240313',
      45.693887,
      3,
      NULL,
      3,
      '032132',
      3.068803,
      '10-21-1975',
      NULL,
      53,
      1,
      NULL,
      1,
      0,
      1,
      0,
      1.041929,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.571688,
      1,
      0,
      1.204679,
      0,
      1.308595,
      0.301193,
      NULL,
      0.323196,
      0.887969,
      0,
      1.460305,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.323044,
      1.270962,
      0.679505,
      0.343512,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.280398,
      0,
      0,
      NULL,
      0.322681,
      NULL,
      0.200673,
      0.292679,
      1.983663,
      NULL,
      0,
      0,
      1,
      0.498461,
      1,
      1,
      NULL,
      1,
      1.041966,
      NULL,
      0,
      NULL,
      1,
      1,
      6.704633,
      0,
      6,
      0.589652,
      NULL,
      1,
      NULL,
      7.540612,
      2.373911,
      NULL,
      3.333219,
      NULL,
      3,
      7.768966,
      6.444664,
      4,
      2,
      0.991149,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.547676,
      NULL,
      NULL,
      NULL,
      5.266388,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.264812,
      0,
      0,
      0.312603,
      0.135659,
      1.249095,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.660103,
      NULL,
      4,
      3,
      2,
      0.016774,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.523670,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.141806,
      1.144559,
      5,
      1,
      1.463751,
      NULL,
      NULL,
      NULL,
      0,
      0.222992,
      1.574443,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.678459,
      0.112243,
      NULL,
      0,
      0,
      2.150164,
      1.447328,
      NULL,
      NULL,
      1.815469,
      0.032965,
      1.827167,
      1.458671,
      0.058558,
      1.740508,
      0.567884,
      1.871725,
      1.202777,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.875920,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '02200',
      '32202',
      '',
      0,
      NULL,
      '',
      NULL,
      1,
      '',
      '',
      '',
      3,
      0,
      0.992748,
      NULL,
      2,
      3,
      0,
      1,
      NULL);
commit;
end;
/


