set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6909717';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-7-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3403',
      '40034412',
      7.254126,
      82,
      '1304241',
      39,
      NULL,
      0,
      NULL,
      '132122',
      4.178991,
      ' 8-24-1975',
      28.642429,
      6,
      NULL,
      NULL,
      1.010223,
      NULL,
      0.570645,
      1.341657,
      NULL,
      1,
      3.288498,
      1.593583,
      NULL,
      1.019764,
      2.527518,
      0.929984,
      2,
      0.233152,
      1,
      0.700600,
      1.106570,
      1.851518,
      1,
      1.972485,
      NULL,
      1,
      1.461822,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.128593,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.610253,
      0.732937,
      0.059024,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.762062,
      0,
      0,
      0.270577,
      NULL,
      0.564528,
      0.199185,
      1,
      0,
      0.180009,
      0,
      0.522564,
      0.510459,
      0,
      NULL,
      NULL,
      1,
      0,
      0.666327,
      NULL,
      NULL,
      NULL,
      0,
      1.641026,
      4,
      0,
      3.274403,
      NULL,
      1.195511,
      NULL,
      1,
      3,
      5,
      3.047316,
      3,
      0,
      NULL,
      4,
      7,
      NULL,
      6.089916,
      0.994122,
      6.106351,
      4.735017,
      1.129298,
      5.033994,
      NULL,
      5,
      1.869439,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.407041,
      0.900723,
      NULL,
      1,
      0.273073,
      NULL,
      0.385997,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      7.805974,
      2.620202,
      2,
      1.528056,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.902817,
      2,
      1.042364,
      NULL,
      NULL,
      NULL,
      4,
      5.858422,
      6,
      6.237168,
      NULL,
      2,
      7.925071,
      1.136554,
      NULL,
      NULL,
      1,
      3.878810,
      0.310416,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1.091994,
      0,
      2.273387,
      3,
      1.487898,
      1.584829,
      2.070865,
      2,
      0,
      1.571215,
      1,
      1.653983,
      1.272306,
      1.093169,
      1.386050,
      0.866874,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.734779,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.346469,
      '22214',
      '01401',
      '',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      5.908675,
      3,
      NULL,
      NULL,
      3.032087,
      7,
      3.047029,
      2.176744,
      3.004485);
commit;
end;
/


