set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9658113';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-1-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '132',
      '42',
      16.471369,
      11,
      NULL,
      12,
      5,
      NULL,
      3,
      '133040',
      2,
      ' 6- 0-1975',
      44.026321,
      NULL,
      2.465001,
      ' 6-21-1989',
      NULL,
      1.580363,
      0.500361,
      0.302922,
      0,
      3,
      1.064619,
      1,
      0,
      1.247238,
      2,
      1.847548,
      4.542420,
      2.111137,
      1.455805,
      NULL,
      10,
      1.434595,
      4.570885,
      NULL,
      NULL,
      5.081180,
      10.476126,
      0,
      4.535489,
      NULL,
      3.883690,
      0.790194,
      NULL,
      NULL,
      1.534494,
      3,
      5,
      0.021580,
      1,
      3,
      0.262319,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.530457,
      NULL,
      NULL,
      NULL,
      2.598320,
      6,
      3,
      NULL,
      5,
      0.858212,
      1.314226,
      2,
      NULL,
      2,
      1,
      NULL,
      1.189050,
      NULL,
      NULL,
      NULL,
      0,
      1,
      5.493469,
      3,
      3.162449,
      0,
      1.623481,
      1,
      9,
      7,
      4,
      3,
      1.625270,
      NULL,
      2,
      NULL,
      5,
      8.176838,
      3,
      5.345943,
      2,
      0.615836,
      NULL,
      NULL,
      2.375193,
      2.574599,
      NULL,
      1,
      NULL,
      0.736397,
      0.462078,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.024086,
      2,
      1,
      NULL,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.730185,
      3.961427,
      2,
      7.831221,
      2,
      2.605181,
      0.218080,
      0.691421,
      2.189985,
      5,
      0.442275,
      0,
      2.629945,
      2.067799,
      0.415699,
      5,
      0.932610,
      NULL,
      4,
      2.680950,
      2,
      5.359464,
      2.303630,
      1,
      0,
      0.219050,
      13,
      NULL,
      5.131198,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1,
      2,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      3,
      1.516545,
      NULL,
      1.707065,
      0,
      0,
      0.115592,
      0.806278,
      0.635496,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.798892,
      1.149269,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.921510,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.658502,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.285896,
      1.393743,
      NULL,
      1,
      NULL,
      0.817655,
      0,
      0.973544,
      '33432',
      '',
      NULL,
      1,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


