set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9753884';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-5-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '002',
      NULL,
      NULL,
      21,
      '2312303',
      80.321725,
      0,
      0,
      3,
      '000104',
      5.919438,
      ' 6-14-2003',
      NULL,
      6,
      0.843769,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.252618,
      0.233184,
      0.393549,
      0.184399,
      NULL,
      NULL,
      0.744969,
      0.927541,
      1,
      NULL,
      0,
      1.739551,
      NULL,
      1.832267,
      1,
      1,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.818407,
      1.474246,
      0.259983,
      1.112147,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.327015,
      1.771768,
      1,
      0.022840,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.425968,
      0,
      NULL,
      0,
      0.164070,
      1.068943,
      1,
      0,
      NULL,
      1,
      1.571811,
      0,
      1.465351,
      0.410756,
      NULL,
      0.209831,
      1.428194,
      1.281107,
      1,
      NULL,
      NULL,
      NULL,
      1.966557,
      1,
      NULL,
      1.227763,
      7,
      1.371228,
      0.535174,
      0,
      0,
      3.742390,
      1.918079,
      0.724446,
      4,
      1,
      2.501811,
      4.627952,
      1,
      7.011550,
      NULL,
      2.385988,
      7,
      0,
      5,
      0.376688,
      1.256031,
      0.753357,
      0.488844,
      NULL,
      NULL,
      0.189810,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.646865,
      0,
      0,
      1,
      0,
      0,
      1.731408,
      1.487842,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      2.778764,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      5.658118,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5.758009,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.693089,
      NULL,
      1,
      1.705316,
      0.848845,
      NULL,
      3,
      1.705195,
      0,
      3,
      0,
      0.902985,
      1,
      NULL,
      NULL,
      0.978163,
      0.658060,
      0.086712,
      1,
      0.569701,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.671531,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '22220',
      '',
      '',
      0.991169,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      0.484814,
      2,
      3,
      1.588236,
      0.791048,
      0,
      2,
      1,
      3.027801);
commit;
end;
/


