set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908205';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-10-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '1',
      NULL,
      NULL,
      '1141341',
      10.664771,
      3,
      NULL,
      3,
      '312044',
      1,
      ' 6-21-1977',
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.650265,
      0.868083,
      1.904410,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.267998,
      2.305088,
      NULL,
      2.841594,
      0,
      0.053714,
      0.530352,
      NULL,
      3.701966,
      1.024921,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.694619,
      0,
      2.763964,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.966435,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.696920,
      0.160969,
      1,
      0,
      NULL,
      NULL,
      1.202812,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3.608589,
      1.938556,
      1,
      5,
      1,
      0,
      1,
      0.819421,
      1,
      0,
      0,
      NULL,
      1.019061,
      0.448873,
      0.407930,
      1,
      0.053154,
      0,
      NULL,
      1.573222,
      0,
      4.663231,
      0,
      NULL,
      0.712630,
      1.824584,
      3.050759,
      NULL,
      NULL,
      NULL,
      NULL,
      0.441540,
      1.855815,
      0.126832,
      0,
      4.194399,
      2,
      0,
      3,
      7,
      6.919070,
      6,
      9.144065,
      0.081349,
      4.419749,
      1,
      0,
      1.578087,
      NULL,
      NULL,
      7,
      0.620226,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.526472,
      1,
      1,
      NULL,
      1.322049,
      0.042220,
      1.940239,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.369234,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.077018,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.551259,
      1,
      NULL,
      0,
      4,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.244003,
      3.034035,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      2,
      0.551434,
      3,
      3,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      0,
      0,
      1.479119,
      1.983013,
      0,
      1.250737,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.716367,
      '40113',
      '',
      NULL,
      1.611416,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


