set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908205';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-8-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '1',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      '200322',
      NULL,
      NULL,
      35,
      NULL,
      0.021047,
      NULL,
      0.934513,
      NULL,
      1,
      0,
      0.335574,
      1.492018,
      0,
      0,
      NULL,
      1,
      6.454448,
      0,
      6,
      6.988158,
      NULL,
      NULL,
      6.840888,
      0.472570,
      NULL,
      3,
      0.518869,
      0,
      6.124692,
      0,
      5.501126,
      0.608426,
      NULL,
      0.336733,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.132211,
      1,
      0.999636,
      3.312070,
      1.710079,
      0.939340,
      2.564128,
      0,
      1.261667,
      1.440473,
      2.690372,
      0.227022,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.699152,
      1,
      3,
      3,
      4,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.210451,
      NULL,
      NULL,
      0,
      1.127296,
      0.976041,
      3.902297,
      0,
      2.571277,
      5.572082,
      0,
      1.684948,
      3.827128,
      0.317788,
      1,
      NULL,
      NULL,
      1,
      0.550065,
      NULL,
      0,
      1.548522,
      NULL,
      0.719935,
      0.714263,
      2.530290,
      0,
      0.375587,
      0.197271,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      5.462466,
      NULL,
      6,
      6,
      3.102315,
      NULL,
      0.942763,
      7.074307,
      NULL,
      1,
      0.263182,
      0,
      2,
      0.641358,
      0,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      2,
      1.430612,
      0.978631,
      1,
      1.219177,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.502537,
      NULL,
      0.704151,
      1,
      NULL,
      1.160141,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.616793,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.633489,
      4,
      5.084535,
      3.284059,
      0,
      0.848678,
      0.582114,
      NULL,
      NULL,
      1.314988,
      13.126580,
      1.670352,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.239537,
      3,
      2.558766,
      1,
      NULL,
      3.606097,
      NULL,
      2.631651,
      0,
      NULL,
      1.592987,
      1,
      0,
      NULL,
      1,
      NULL,
      1,
      0.312613,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.047085,
      '43332',
      NULL,
      '',
      0.120875,
      '',
      '',
      '',
      0,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


