set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908205';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-4-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      NULL,
      NULL,
      NULL,
      NULL,
      26,
      5,
      3.047018,
      3,
      '001333',
      NULL,
      NULL,
      46.910230,
      NULL,
      NULL,
      NULL,
      2.261683,
      0,
      0,
      1,
      0,
      2,
      1.182667,
      NULL,
      0.255274,
      0.884751,
      9.163191,
      0,
      1,
      1,
      NULL,
      0.161804,
      7.112423,
      0.512177,
      3,
      NULL,
      0.932427,
      0,
      1.660548,
      NULL,
      3.670464,
      1,
      0,
      1.278914,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.503989,
      NULL,
      1.661207,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      2,
      0.797305,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.782859,
      0.656327,
      4.134317,
      1.613785,
      NULL,
      2.381682,
      1,
      1,
      0.115135,
      4.512384,
      1.428369,
      2.471182,
      0.398773,
      NULL,
      0,
      1,
      1,
      1,
      0.652345,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      1.979670,
      0.190030,
      1.299280,
      2,
      NULL,
      3,
      NULL,
      NULL,
      4,
      0,
      NULL,
      2,
      1.663799,
      NULL,
      6.829526,
      7,
      3,
      9.961740,
      6,
      6,
      3,
      4.201857,
      NULL,
      1.073245,
      0.674243,
      1.302853,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.104459,
      0,
      NULL,
      NULL,
      0.574428,
      0,
      1.528385,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.308923,
      NULL,
      6.762047,
      2.405410,
      2,
      7,
      1.626680,
      0.027291,
      0.743962,
      1,
      0.461858,
      2,
      1,
      1.128457,
      NULL,
      NULL,
      NULL,
      8,
      0.277269,
      0.068904,
      4.019711,
      3,
      2,
      3,
      NULL,
      NULL,
      NULL,
      1,
      14.658199,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.191383,
      NULL,
      NULL,
      1.294864,
      0.672987,
      NULL,
      1.835985,
      2,
      1.820334,
      0,
      2.976377,
      0,
      0,
      0,
      0,
      1,
      NULL,
      1,
      1.863513,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.099456,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '04233',
      '',
      '',
      0,
      '',
      NULL,
      NULL,
      0.612119,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


