set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908205';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-6-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '3',
      NULL,
      NULL,
      '1134430',
      5,
      5,
      NULL,
      1,
      '303242',
      0,
      ' 6- 3-1987',
      7,
      NULL,
      1,
      NULL,
      0.669528,
      0,
      1,
      1.421861,
      NULL,
      3,
      NULL,
      0,
      0.744013,
      1,
      4,
      0.932219,
      2.935967,
      NULL,
      1.386820,
      0.752744,
      7,
      0,
      4.850521,
      2,
      NULL,
      0.232729,
      NULL,
      1,
      0.198865,
      NULL,
      0,
      1.679727,
      NULL,
      NULL,
      1.277001,
      NULL,
      NULL,
      5,
      NULL,
      0.756273,
      2.417815,
      0,
      1.854964,
      3.076597,
      0.416181,
      3,
      0,
      3.760999,
      0.791015,
      3.072160,
      NULL,
      1.855592,
      0.334187,
      3.829856,
      1.473054,
      1.422168,
      1,
      NULL,
      0,
      8.950888,
      1,
      2,
      1.900407,
      0.274459,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.830523,
      2.866050,
      1,
      0,
      3.385411,
      1,
      1,
      1,
      1,
      1.686106,
      1.911929,
      1,
      0.468485,
      NULL,
      1,
      1.110668,
      0.047201,
      0.367264,
      NULL,
      NULL,
      NULL,
      0.205837,
      6.929687,
      6.301331,
      5.653174,
      2,
      6.241284,
      1,
      2.774250,
      0.463666,
      5.814753,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5,
      7.502907,
      4.542195,
      0,
      3.168144,
      2,
      2.210416,
      NULL,
      3,
      NULL,
      13,
      2,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.738221,
      NULL,
      1,
      0,
      0,
      2,
      3,
      0.775179,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.542877,
      NULL,
      2.383549,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.457078,
      1.903141,
      NULL,
      NULL,
      NULL,
      3,
      1.313385,
      11.156825,
      NULL,
      7.411013,
      1,
      1.133496,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.810377,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.876090,
      3,
      1,
      0.431229,
      0.851044,
      1,
      NULL,
      1.582368,
      1,
      NULL,
      1.224336,
      1.777365,
      1.074727,
      1.146313,
      1,
      0.333470,
      0.919429,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '44432',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


