set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908205';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-6-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      NULL,
      NULL,
      NULL,
      NULL,
      41,
      2,
      NULL,
      NULL,
      '002204',
      0,
      ' 1-24-1993',
      34.851927,
      NULL,
      0,
      NULL,
      0,
      2.335392,
      1.936562,
      1,
      0.291840,
      0,
      1.584503,
      1.981642,
      0,
      1.515100,
      3,
      1.359984,
      8.308982,
      NULL,
      NULL,
      1.261397,
      10.411107,
      1,
      1,
      5,
      0.262991,
      0,
      3.581944,
      0,
      4.203242,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      4.525715,
      0.810336,
      0,
      2.051315,
      0.146226,
      1,
      1.710504,
      0,
      2,
      NULL,
      2,
      NULL,
      1,
      3,
      0.646515,
      0.694348,
      NULL,
      0,
      1,
      NULL,
      0,
      2,
      NULL,
      0,
      NULL,
      0.793766,
      1.032969,
      NULL,
      NULL,
      NULL,
      4,
      0.210898,
      3,
      0.416380,
      0,
      0,
      1.488630,
      0.507111,
      2.266345,
      0.896363,
      NULL,
      1,
      0.278996,
      0,
      0.142816,
      NULL,
      1,
      1.721349,
      1,
      1,
      1.430629,
      NULL,
      0.034144,
      1.002036,
      1.609924,
      1.898510,
      1.237861,
      NULL,
      4,
      0,
      2,
      1,
      NULL,
      3.557562,
      0,
      1.305219,
      6,
      NULL,
      7,
      4,
      NULL,
      0.217314,
      9.160165,
      NULL,
      2,
      7.023425,
      6,
      5,
      1,
      3.915587,
      0.223026,
      1.939946,
      1.169148,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.186776,
      2,
      0,
      0.404274,
      0,
      0.297693,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.122426,
      NULL,
      0.385148,
      2,
      3,
      4.604572,
      1,
      0,
      2,
      0.955199,
      2.018851,
      10,
      3.115772,
      1.702665,
      NULL,
      NULL,
      NULL,
      3.949371,
      1.018956,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      2.924948,
      NULL,
      NULL,
      4,
      0,
      0.306684,
      NULL,
      0.099098,
      NULL,
      0,
      2,
      1,
      1.251612,
      3.953627,
      NULL,
      NULL,
      0.345475,
      1,
      3.509328,
      0,
      0,
      0,
      1.093846,
      1,
      0.097903,
      NULL,
      NULL,
      1.616875,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      0.771528,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


