set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908205';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-7-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '3',
      NULL,
      NULL,
      '0010010',
      NULL,
      4,
      3,
      1,
      NULL,
      0.313376,
      ' 7-23-2000',
      15.830189,
      NULL,
      1,
      NULL,
      3,
      1,
      1.039687,
      0,
      NULL,
      NULL,
      1.505237,
      1.517062,
      0,
      1,
      0,
      1,
      5,
      NULL,
      NULL,
      0.615867,
      7.512807,
      0.018435,
      3,
      0,
      NULL,
      1,
      NULL,
      0,
      5.372348,
      1.567357,
      1,
      1,
      NULL,
      NULL,
      1,
      1.426618,
      0.889215,
      5.072799,
      0,
      NULL,
      1.696980,
      0,
      1.390131,
      2,
      2,
      0,
      1.723465,
      NULL,
      0,
      1,
      1.970049,
      1.156154,
      1.332790,
      0.735640,
      1.398288,
      NULL,
      NULL,
      1.206164,
      1,
      7,
      0,
      0,
      0,
      1.628412,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.220781,
      5,
      1.367207,
      0,
      1.199172,
      1.138192,
      1.496531,
      1.925280,
      1.474708,
      0,
      1,
      1.820743,
      NULL,
      1.342931,
      NULL,
      0.637318,
      0,
      4.527275,
      2.925355,
      3.369926,
      3,
      5.172928,
      NULL,
      0,
      1,
      7.601607,
      7.611012,
      7.535208,
      6.162637,
      0,
      0.321088,
      NULL,
      1,
      2.821137,
      4,
      NULL,
      0.178565,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      3.773990,
      0,
      1.524566,
      5.843583,
      1.165869,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.337251,
      0.497184,
      2,
      0,
      NULL,
      0,
      NULL,
      0.496430,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.018398,
      NULL,
      3.307406,
      NULL,
      0.846256,
      NULL,
      0.291243,
      0,
      1.923264,
      NULL,
      0.016427,
      3.187528,
      0.174572,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.364639,
      5.790268,
      8,
      0,
      1,
      NULL,
      NULL,
      NULL,
      2,
      2,
      1.522095,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      0,
      2.861987,
      3,
      2,
      NULL,
      0,
      0,
      3.560766,
      1.923867,
      1,
      1,
      0.314003,
      0,
      0,
      1,
      0.122728,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.367782,
      '01331',
      '',
      '',
      0,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


