set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908205';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-12-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '1',
      NULL,
      NULL,
      NULL,
      30,
      2,
      1.407894,
      3,
      '034332',
      3,
      '10-19-1990',
      24.168148,
      NULL,
      NULL,
      NULL,
      2.406244,
      1,
      2,
      0,
      0,
      0.674639,
      NULL,
      1.776025,
      0,
      1,
      7,
      NULL,
      0,
      NULL,
      0.191896,
      3,
      3.264849,
      NULL,
      4,
      0,
      1,
      0,
      6,
      0,
      3.882056,
      1.875814,
      1.100499,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.968894,
      0.339767,
      0,
      0.459039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.536450,
      0.420264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      4,
      NULL,
      5,
      5,
      0.352839,
      1.215562,
      1.629665,
      NULL,
      3,
      4.448097,
      1.279428,
      5.133302,
      1.183868,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.586569,
      NULL,
      1,
      1.935340,
      1.717833,
      NULL,
      NULL,
      3,
      1.171406,
      0,
      0,
      NULL,
      1.128733,
      2.531791,
      NULL,
      7.431376,
      NULL,
      7,
      1,
      NULL,
      5,
      4,
      NULL,
      6.303388,
      4,
      1.815155,
      5.492304,
      1.758718,
      0.949789,
      1.211428,
      3,
      0.762114,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.092066,
      3.008067,
      1,
      0,
      0,
      2,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1,
      1.750484,
      0.990946,
      3,
      NULL,
      6.870879,
      2.780372,
      0,
      NULL,
      NULL,
      NULL,
      0.003034,
      0.762110,
      1,
      6.163289,
      6.993302,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.417165,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.323819,
      0,
      0.652656,
      1.194493,
      0,
      3.017792,
      3,
      0.320023,
      NULL,
      3,
      1,
      2.624810,
      1.523027,
      1.579929,
      0,
      NULL,
      0,
      1,
      1.421155,
      1,
      1,
      1,
      0.837225,
      2.324775,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '33424',
      '',
      '',
      0.005230,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


