set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9766478';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-2-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '304',
      '02114312',
      NULL,
      20,
      '1002414',
      19,
      4,
      3,
      NULL,
      '140140',
      2.502119,
      ' 4-19-1993',
      136,
      33,
      0,
      NULL,
      NULL,
      0.748100,
      NULL,
      0.389576,
      1,
      NULL,
      0.516414,
      2.459450,
      3,
      NULL,
      0,
      1,
      3,
      NULL,
      0.221278,
      NULL,
      2.924929,
      1.526693,
      0,
      0,
      0,
      0.326682,
      0.381644,
      NULL,
      4.683967,
      0.412625,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.483039,
      NULL,
      0.786839,
      0,
      1.073309,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.612627,
      0.757503,
      3.711892,
      NULL,
      0.106332,
      NULL,
      2.935079,
      NULL,
      1.869726,
      NULL,
      3,
      0,
      NULL,
      0,
      0.388236,
      NULL,
      NULL,
      0.632499,
      NULL,
      NULL,
      1.034646,
      3,
      1.177314,
      NULL,
      4.345920,
      4.032359,
      5,
      0.830645,
      0.093628,
      NULL,
      1.145558,
      1,
      0,
      NULL,
      1.862046,
      1,
      0.543388,
      1.226845,
      NULL,
      NULL,
      1.304001,
      NULL,
      6.421279,
      NULL,
      0,
      1,
      2.450011,
      0,
      0,
      0,
      1,
      0,
      0,
      0.047847,
      0.276675,
      NULL,
      NULL,
      NULL,
      0.423908,
      0.144963,
      3,
      3.379216,
      1,
      4.511638,
      NULL,
      3.356909,
      1,
      1.794033,
      NULL,
      1.109448,
      0.311057,
      8.970577,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      0.097803,
      NULL,
      1.072304,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.885021,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.208027,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.621270,
      0.617941,
      6.071603,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.067385,
      2.301381,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      0.160273,
      3,
      0.980516,
      3,
      2.123478,
      0.939727,
      1.724761,
      1.917170,
      1,
      NULL,
      0,
      0,
      NULL,
      0.384942,
      1,
      NULL,
      0.020913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '00421',
      '',
      NULL,
      1,
      '',
      '',
      '',
      0.708732,
      NULL,
      '',
      '',
      1.872532,
      5,
      2,
      3.424438,
      2,
      NULL,
      NULL,
      0,
      2.466232);
commit;
end;
/


