set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9766478';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-5-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '42321104',
      46,
      38.227891,
      '4041010',
      NULL,
      2,
      1,
      0,
      NULL,
      4,
      ' 9-23-2003',
      133,
      275.206834,
      0.332985,
      NULL,
      1,
      1,
      3,
      1,
      0.222119,
      1,
      0.304680,
      0.973767,
      1.102885,
      0.156132,
      0.077101,
      1,
      2.037557,
      0,
      1.537166,
      2,
      0,
      NULL,
      1.085899,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.466199,
      0,
      1.932348,
      NULL,
      NULL,
      1.596690,
      NULL,
      NULL,
      2,
      1.804570,
      NULL,
      1,
      0.977574,
      0.448699,
      3.608236,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      3.938433,
      1,
      3,
      0.327436,
      NULL,
      1.160727,
      NULL,
      3,
      NULL,
      1,
      2,
      1.511162,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      8,
      1.140903,
      1,
      1.966527,
      2.895973,
      0,
      1.277177,
      1.108763,
      0.931142,
      0,
      1.506237,
      NULL,
      4,
      0,
      1.242262,
      1.654967,
      0.808464,
      0,
      NULL,
      1.868777,
      NULL,
      6.008301,
      2.210022,
      5.592968,
      1,
      NULL,
      1.558456,
      NULL,
      NULL,
      2,
      NULL,
      1.067032,
      0,
      5,
      1.903616,
      2,
      NULL,
      1,
      NULL,
      6.875471,
      NULL,
      2.747424,
      7.668363,
      NULL,
      5.745079,
      1,
      NULL,
      0.508125,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.585825,
      0,
      NULL,
      NULL,
      NULL,
      7.220772,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.952581,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.167620,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.428119,
      0,
      3,
      0,
      1.126505,
      0,
      0.098686,
      NULL,
      NULL,
      NULL,
      NULL,
      5.554280,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.061325,
      1.908846,
      NULL,
      NULL,
      0,
      1.252110,
      3.872366,
      1.682627,
      2,
      2,
      3,
      0,
      0.526345,
      1.582038,
      1.914422,
      1,
      1,
      1,
      1.972818,
      1.723499,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.864707,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.859570,
      '03114',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      4,
      3.169722,
      1,
      0,
      0.975729,
      3.563003,
      0,
      0.139078,
      1);
commit;
end;
/


