set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9766478';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '40024113',
      NULL,
      79.969404,
      '4134100',
      NULL,
      5,
      1.915747,
      1,
      '200232',
      5,
      '11-10-2002',
      49,
      50,
      NULL,
      NULL,
      4,
      1,
      1.601175,
      1,
      NULL,
      0.645686,
      1,
      1,
      0,
      1,
      0.700561,
      0.040520,
      1.142726,
      1,
      0,
      1.558981,
      NULL,
      0.203118,
      1,
      1,
      0.519433,
      0.942436,
      NULL,
      0,
      2.897739,
      2.229191,
      NULL,
      1.343524,
      NULL,
      NULL,
      0.711950,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1.533999,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.411832,
      1,
      1.430880,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.793483,
      2.147972,
      1.274180,
      6,
      1,
      2.043024,
      0,
      0,
      1,
      1.336641,
      1.382104,
      NULL,
      2.455055,
      1,
      0,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      0.750975,
      NULL,
      1,
      1.706565,
      6.355672,
      1,
      2,
      NULL,
      1.761297,
      4.176722,
      0.349951,
      1,
      0.057790,
      0,
      1.092318,
      NULL,
      0,
      0,
      NULL,
      3.598863,
      5.819449,
      2.318922,
      NULL,
      4,
      0,
      5,
      NULL,
      1,
      NULL,
      7.230842,
      0.889102,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.001106,
      0.250507,
      NULL,
      2,
      1,
      3.444779,
      0.775961,
      1.871729,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.422590,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.811833,
      0,
      0.826273,
      3.705312,
      2,
      2.647539,
      2,
      0.092132,
      3.532671,
      1.671493,
      1,
      1,
      1.274971,
      1,
      0.226152,
      0.711670,
      1,
      0.268283,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.894863,
      0.041601,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.260308,
      1.143745,
      0.412773,
      NULL,
      0,
      NULL,
      1.102380,
      1.610000,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.064949,
      NULL,
      NULL,
      NULL,
      NULL,
      0.223252,
      NULL,
      NULL,
      NULL,
      NULL,
      0.906707,
      NULL,
      1.528011,
      NULL,
      1.033465,
      NULL,
      0.864301,
      1,
      2,
      '40430',
      '',
      '',
      1.499011,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      5.969151,
      1.764277,
      2,
      1.560862,
      0.458823,
      1.843400,
      0.229808,
      NULL,
      2.150162);
commit;
end;
/


