set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9766478';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-7-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3332',
      '30401212',
      61,
      44,
      '0442403',
      24,
      4,
      1,
      3,
      '413032',
      1,
      NULL,
      18,
      NULL,
      0.799591,
      NULL,
      NULL,
      0,
      0,
      0.574415,
      NULL,
      1.156242,
      0.342516,
      NULL,
      3,
      NULL,
      0,
      0,
      0,
      1,
      2.735489,
      0.792713,
      6,
      0,
      1.962363,
      0.680052,
      1,
      0,
      2,
      0,
      1,
      0.712939,
      0,
      0,
      NULL,
      NULL,
      0.853137,
      NULL,
      NULL,
      6,
      0.062762,
      NULL,
      1.854469,
      1.019910,
      NULL,
      0,
      2,
      1,
      0.976686,
      2.965194,
      0,
      0,
      0.745875,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.485910,
      5,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      0.174929,
      NULL,
      NULL,
      1.744732,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      0.471476,
      1.097244,
      1.789277,
      1,
      NULL,
      1,
      1.383207,
      0.866779,
      NULL,
      0,
      1,
      1.609089,
      NULL,
      0,
      4,
      0,
      2.068417,
      2,
      1.106412,
      NULL,
      1,
      1,
      1,
      1.154996,
      NULL,
      0.331418,
      0,
      3,
      1.930669,
      NULL,
      1.256715,
      0,
      1,
      4.877450,
      2.220701,
      4.077981,
      NULL,
      2.873009,
      5,
      0,
      3.506521,
      2,
      0,
      1,
      9.376487,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      1,
      0.291184,
      1.803321,
      1.664784,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.565268,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.525845,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.451626,
      1.878804,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.120221,
      1.219599,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.994163,
      0,
      0,
      3,
      1.942638,
      NULL,
      1,
      0.913977,
      0,
      0,
      0.653247,
      0,
      NULL,
      NULL,
      0,
      0,
      1.549880,
      1,
      1,
      0.307895,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.533157,
      '13403',
      '01122',
      '',
      0.265114,
      '',
      NULL,
      '',
      0.381355,
      '',
      NULL,
      '',
      NULL,
      1,
      NULL,
      1,
      2,
      NULL,
      2,
      0,
      0.333536);
commit;
end;
/


