set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9766478';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-11-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3022',
      '21144123',
      17.103334,
      NULL,
      '0033412',
      68,
      NULL,
      1.961689,
      3,
      '231244',
      4.397196,
      NULL,
      28.416575,
      37,
      0,
      NULL,
      14.523314,
      NULL,
      NULL,
      1.868196,
      1,
      2.460016,
      0,
      1.181116,
      NULL,
      0,
      5,
      0.493956,
      0,
      0,
      NULL,
      1,
      4.791338,
      1.849053,
      2,
      0,
      1.902015,
      1.754783,
      3.687455,
      1,
      2.488282,
      3.965582,
      1.158012,
      1,
      NULL,
      NULL,
      1.957660,
      NULL,
      NULL,
      6,
      NULL,
      1,
      0.179580,
      0.705148,
      0.717827,
      0.949924,
      NULL,
      0,
      3.175152,
      2,
      1,
      1.857427,
      3.840848,
      1,
      2,
      0,
      NULL,
      1.873799,
      0.206911,
      0.392454,
      1,
      5.183471,
      NULL,
      1,
      3,
      1.343644,
      NULL,
      NULL,
      0.587892,
      NULL,
      NULL,
      NULL,
      0.375493,
      1.441041,
      0.413634,
      NULL,
      0,
      1,
      1.089330,
      1.776489,
      1.179216,
      1,
      0.796422,
      NULL,
      NULL,
      0.652372,
      0,
      0,
      0.143123,
      0,
      NULL,
      NULL,
      3,
      0,
      0.353196,
      1.179754,
      NULL,
      NULL,
      0.333809,
      0,
      0,
      1,
      1.469806,
      NULL,
      5.306984,
      NULL,
      0.788132,
      0.376517,
      2.925409,
      2.153533,
      2,
      2,
      NULL,
      2,
      7.507330,
      0.793764,
      0.903854,
      4.660926,
      NULL,
      3,
      NULL,
      1,
      3.557910,
      0.001761,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.015604,
      0,
      0,
      0.953458,
      0.798662,
      0.987010,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.235100,
      0.393329,
      0.743976,
      NULL,
      NULL,
      NULL,
      0.113723,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.767937,
      NULL,
      NULL,
      NULL,
      0.448281,
      0.642256,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3.329421,
      0.682330,
      0,
      NULL,
      0.975192,
      3,
      1.041904,
      1,
      NULL,
      NULL,
      0,
      0.101949,
      1,
      1.021550,
      0,
      0.034204,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.534079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.454847,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.169249,
      8,
      NULL,
      1.792132,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.947019,
      NULL,
      NULL,
      0,
      0,
      1,
      2,
      NULL,
      '11142',
      '12231',
      '34234',
      0.658648,
      '',
      '',
      NULL,
      1,
      '',
      NULL,
      '',
      1.556411,
      0,
      0.165230,
      1,
      0,
      1.366553,
      NULL,
      4,
      NULL);
commit;
end;
/


