set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9856715';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-7-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '231',
      '12120322',
      76,
      2.783675,
      NULL,
      3,
      0,
      0,
      NULL,
      '442420',
      4.834331,
      ' 6- 6-1995',
      36,
      3,
      0.162946,
      NULL,
      2,
      1.168569,
      2,
      1,
      1.532309,
      2.205801,
      1,
      0.003587,
      2.632948,
      1,
      NULL,
      0.020018,
      0.992607,
      0.253670,
      0,
      4.017944,
      1.690374,
      2,
      3.355785,
      2.925585,
      NULL,
      1,
      NULL,
      0,
      0.708453,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      0.487017,
      NULL,
      1.559158,
      1.403353,
      1,
      3,
      1.326783,
      NULL,
      0.045448,
      3.557221,
      2.028667,
      2.409159,
      NULL,
      1,
      NULL,
      0,
      1.679997,
      0,
      NULL,
      1,
      9,
      0,
      2,
      1,
      0.114454,
      NULL,
      NULL,
      0.909922,
      NULL,
      NULL,
      3,
      2.753962,
      3,
      0,
      2,
      1.897509,
      NULL,
      0,
      4.034825,
      0,
      0,
      0,
      0.228442,
      NULL,
      1.273284,
      0,
      0.213444,
      0.537876,
      0,
      NULL,
      0.483902,
      NULL,
      NULL,
      0.739695,
      NULL,
      0.411377,
      2,
      1,
      NULL,
      NULL,
      3.741316,
      1,
      3,
      1,
      7,
      1,
      1,
      5,
      NULL,
      1,
      7,
      5,
      2,
      1.304961,
      2.371051,
      0,
      3,
      3,
      NULL,
      1,
      1.479128,
      2.415242,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.668437,
      0.520533,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.330650,
      NULL,
      9,
      2,
      3,
      0,
      3,
      NULL,
      1.209558,
      0,
      6.401776,
      7.375453,
      2.213045,
      0.738889,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      5,
      6.314573,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.957182,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.456079,
      1.303362,
      2.421165,
      1.505585,
      NULL,
      3.086902,
      3,
      1.297729,
      NULL,
      3,
      0,
      0,
      0,
      0,
      1,
      NULL,
      1.924958,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.676570,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '42302',
      '',
      '',
      0.809917,
      '',
      '',
      '',
      2.952091,
      '1402',
      '',
      '',
      NULL,
      1.397340,
      5,
      1,
      0.502057,
      0,
      NULL,
      1,
      0.294515);
commit;
end;
/


