set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9856715';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-12-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '334',
      '13312022',
      57,
      50.325995,
      '0030104',
      12.960148,
      5,
      1.141969,
      0,
      '122323',
      4.910102,
      NULL,
      5.769698,
      41.743410,
      1.525181,
      NULL,
      0,
      1,
      3,
      NULL,
      1,
      NULL,
      0,
      1,
      0.100917,
      1.479152,
      0.032979,
      1,
      5,
      2,
      1,
      4.167230,
      7,
      NULL,
      1.309854,
      2.787777,
      NULL,
      NULL,
      3,
      0,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      0.422392,
      NULL,
      NULL,
      4.268205,
      NULL,
      1,
      3,
      1,
      1,
      0,
      NULL,
      3.131737,
      NULL,
      NULL,
      3.025268,
      2,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      5,
      1,
      NULL,
      NULL,
      0.655941,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.267076,
      NULL,
      3,
      0,
      3.130764,
      1,
      NULL,
      NULL,
      1.602110,
      NULL,
      0.815411,
      1.296847,
      0.335827,
      1.190874,
      0.187275,
      1.954525,
      NULL,
      0.806571,
      1.345904,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.276584,
      NULL,
      0,
      1.963977,
      6.674937,
      4.757955,
      2,
      2.191948,
      4.283547,
      NULL,
      2,
      NULL,
      0.891389,
      5.860285,
      3.675577,
      0.680331,
      0,
      1,
      5.465920,
      10.324412,
      NULL,
      1,
      5,
      0,
      2.881142,
      0,
      0,
      3.225741,
      0.704271,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.936258,
      0,
      NULL,
      NULL,
      0,
      0.174149,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      6.840732,
      NULL,
      3.323943,
      3,
      2.849090,
      2,
      1,
      0.481799,
      0.260274,
      1,
      NULL,
      0.087149,
      NULL,
      NULL,
      NULL,
      1.361362,
      0.744165,
      0,
      0.863644,
      6,
      0,
      7,
      0,
      NULL,
      NULL,
      NULL,
      11.701464,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      3.038156,
      1.959572,
      3,
      1.228254,
      NULL,
      0,
      NULL,
      0.088333,
      1.754411,
      0.253499,
      1.225689,
      1,
      NULL,
      0.694897,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.524321,
      '24424',
      '',
      NULL,
      1.893513,
      NULL,
      '',
      '',
      1.502263,
      '3200',
      '',
      NULL,
      1,
      NULL,
      2.926414,
      1.430915,
      0,
      3,
      1.727767,
      1,
      2.441537);
commit;
end;
/


