set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9856715';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-7-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3043',
      NULL,
      59.488781,
      57,
      '3122120',
      5.599935,
      5,
      3,
      1,
      NULL,
      3.069000,
      ' 6- 5-1981',
      54.394203,
      2,
      0.028050,
      NULL,
      3.095801,
      0.498057,
      NULL,
      0,
      1.339226,
      1.824344,
      NULL,
      1,
      3.572938,
      0,
      6,
      1.782225,
      2,
      0,
      1,
      NULL,
      4.062834,
      1.418290,
      0.514054,
      1,
      1,
      4,
      0.609928,
      NULL,
      0,
      1.998085,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      8,
      7.761450,
      NULL,
      1.314852,
      NULL,
      1,
      3.897126,
      NULL,
      1,
      NULL,
      0.391627,
      NULL,
      1,
      2,
      NULL,
      0.312778,
      1,
      1.176175,
      1.430396,
      NULL,
      0.738616,
      0.230299,
      1.548735,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.808028,
      NULL,
      NULL,
      1,
      1,
      3.512063,
      3,
      2.020789,
      1,
      0.819550,
      1.712421,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      0.815234,
      0.279886,
      1,
      NULL,
      NULL,
      NULL,
      1.992745,
      1,
      1,
      0.161099,
      1.180045,
      0,
      NULL,
      2,
      1,
      3.320975,
      NULL,
      NULL,
      2,
      2.707830,
      0,
      1,
      1,
      3,
      8.801107,
      7,
      3,
      5.803385,
      0,
      2,
      1.020609,
      2.505960,
      3,
      1,
      0,
      NULL,
      1.340232,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.470335,
      0.259581,
      0,
      1,
      NULL,
      1,
      0,
      0.245871,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.979606,
      NULL,
      7,
      1.786775,
      2,
      6,
      2.254650,
      3.398431,
      1,
      0.899544,
      1,
      2.540395,
      2.046583,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.522303,
      7,
      0.181625,
      NULL,
      5.720360,
      1.249102,
      NULL,
      NULL,
      0.830583,
      NULL,
      0.678314,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.396015,
      1,
      NULL,
      1,
      3,
      3,
      2.638510,
      2,
      1.032972,
      0,
      0,
      1.322980,
      1.001363,
      0,
      0.515447,
      0,
      1.977825,
      1.696800,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.904073,
      '40040',
      NULL,
      '',
      0.036651,
      '',
      NULL,
      '',
      2,
      '4241',
      NULL,
      '',
      NULL,
      1,
      0,
      NULL,
      2.467636,
      2,
      NULL,
      3.257548,
      NULL);
commit;
end;
/


