set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9856715';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-12-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4432',
      '21003441',
      NULL,
      NULL,
      '0443031',
      41.228023,
      4,
      2,
      2,
      '120222',
      2,
      NULL,
      37,
      52.937453,
      0.699784,
      NULL,
      NULL,
      1,
      3,
      0.983999,
      NULL,
      0.427063,
      NULL,
      0.018727,
      1,
      0.726383,
      6.137454,
      1.568164,
      2,
      1,
      1,
      1,
      0.777167,
      1.975613,
      5,
      6.503973,
      0.291121,
      NULL,
      4.112833,
      0,
      2.845304,
      1.578829,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.674381,
      NULL,
      2.819563,
      NULL,
      NULL,
      0.913666,
      1,
      NULL,
      1.321912,
      3,
      2.325472,
      1.718663,
      NULL,
      2,
      1.133026,
      NULL,
      1,
      0,
      1.042063,
      NULL,
      0.753750,
      7.795573,
      2,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.931681,
      0,
      4.733196,
      1.891559,
      NULL,
      1.186330,
      0.044372,
      0,
      0.921172,
      1.979578,
      1.209534,
      NULL,
      0.239717,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.630422,
      5,
      0,
      1.100823,
      NULL,
      1,
      4.365059,
      1,
      2.308989,
      NULL,
      NULL,
      1.552189,
      1,
      3,
      NULL,
      0,
      1.684287,
      4.715964,
      5,
      2,
      4.108268,
      NULL,
      2.733723,
      3,
      7,
      NULL,
      NULL,
      4.580729,
      0,
      NULL,
      1.600798,
      4.746560,
      1.667597,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.034335,
      NULL,
      0,
      1,
      NULL,
      1.025396,
      0.488715,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.827466,
      NULL,
      NULL,
      NULL,
      3.923678,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.783285,
      0.695180,
      NULL,
      NULL,
      NULL,
      1,
      7.965315,
      NULL,
      NULL,
      NULL,
      1.155011,
      8.800834,
      0.138859,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.306800,
      2.556739,
      3,
      3,
      NULL,
      1.710273,
      0.787201,
      0,
      0.226843,
      NULL,
      1,
      0.606677,
      1,
      1,
      0,
      0.842625,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.510453,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '02100',
      '',
      '',
      0,
      '',
      '',
      '',
      3,
      '2001',
      '',
      '',
      3,
      2.627174,
      1,
      NULL,
      1,
      2,
      0,
      NULL,
      1.846500);
commit;
end;
/


