set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9856715';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-6-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2430',
      '42332001',
      87,
      22,
      '3312334',
      NULL,
      2,
      NULL,
      0,
      '104030',
      2,
      NULL,
      NULL,
      NULL,
      1.532155,
      NULL,
      2.358983,
      0.956258,
      1,
      1.648387,
      0,
      0.071964,
      1.227835,
      1,
      NULL,
      NULL,
      NULL,
      0.178816,
      5.472445,
      1.343518,
      1.749210,
      0,
      1,
      0.391866,
      NULL,
      7.126677,
      2.598589,
      NULL,
      1.140220,
      1,
      NULL,
      0.898924,
      1.465153,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      7.525447,
      1.607801,
      3,
      1,
      1.174877,
      3,
      2.272678,
      0,
      1.508424,
      0,
      2.593103,
      2,
      1.377055,
      1,
      3.032711,
      NULL,
      1,
      1,
      2,
      0.590368,
      0.625777,
      NULL,
      0,
      NULL,
      1.374969,
      NULL,
      NULL,
      NULL,
      1.965236,
      NULL,
      NULL,
      1,
      0.203834,
      1,
      2.444001,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      1.132503,
      NULL,
      NULL,
      0.182365,
      0,
      0.019030,
      1.204532,
      1,
      1,
      NULL,
      1.535218,
      1.719280,
      0,
      1,
      4.479976,
      NULL,
      4,
      0.168445,
      0.412059,
      2,
      5.855473,
      6,
      0,
      3,
      5.945331,
      0.010884,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      4.406897,
      6,
      9.573578,
      5.742145,
      1,
      2.548319,
      2,
      0,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.093935,
      2,
      NULL,
      1,
      NULL,
      1.785315,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.539615,
      NULL,
      0.802195,
      1,
      2.236547,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.843740,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.843245,
      5,
      6,
      2,
      3,
      1.743777,
      NULL,
      NULL,
      1,
      5.818923,
      0.806837,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.950032,
      1.230358,
      2.276838,
      NULL,
      NULL,
      1.172885,
      NULL,
      1.906012,
      0.101947,
      1,
      1.031053,
      0,
      NULL,
      1.519972,
      0.768106,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.423027,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '14424',
      '',
      '',
      0.255470,
      '',
      '',
      NULL,
      2,
      NULL,
      '',
      '',
      NULL,
      0,
      0.868235,
      NULL,
      3.579832,
      NULL,
      NULL,
      0,
      2);
commit;
end;
/


