set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9856715';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-2-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2111',
      NULL,
      2.060064,
      NULL,
      '2302422',
      14.443096,
      3,
      2,
      NULL,
      NULL,
      0.124240,
      ' 6- 7-1987',
      32.641528,
      NULL,
      1,
      NULL,
      3,
      0.206296,
      0.717712,
      1.549231,
      0.544721,
      0,
      0.407271,
      NULL,
      1.823459,
      0,
      NULL,
      1.953613,
      NULL,
      1.449615,
      1,
      2,
      NULL,
      0.586952,
      3,
      NULL,
      0,
      1.310260,
      0.036033,
      NULL,
      3,
      3.094824,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      4,
      2.877347,
      2,
      0,
      1,
      1,
      0,
      2,
      1,
      0.312126,
      2.545978,
      NULL,
      3.928829,
      1.638170,
      3,
      NULL,
      1,
      1.758228,
      1.210452,
      NULL,
      1.179846,
      NULL,
      NULL,
      2,
      0,
      0.109381,
      NULL,
      NULL,
      0.683566,
      NULL,
      NULL,
      1,
      5,
      NULL,
      4,
      4,
      0,
      1.743532,
      1.906464,
      0,
      0,
      NULL,
      1.829343,
      NULL,
      1,
      0.282386,
      1.154068,
      1.285055,
      0,
      0.048621,
      NULL,
      0.863920,
      NULL,
      NULL,
      1,
      NULL,
      0.000919,
      5.237477,
      0,
      2.462136,
      2,
      1.910788,
      4.742763,
      4,
      NULL,
      5,
      NULL,
      1,
      2.197949,
      4,
      0.196890,
      5,
      NULL,
      3.426908,
      1.139248,
      8.386764,
      1.782355,
      0,
      1,
      3,
      1,
      1,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.058111,
      1.178203,
      1,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.607426,
      NULL,
      4.689436,
      NULL,
      NULL,
      1.539719,
      3.493825,
      1.498605,
      1.671704,
      1.465500,
      1,
      4.972447,
      3.750230,
      1,
      NULL,
      NULL,
      NULL,
      0.131545,
      1.697506,
      0.108444,
      NULL,
      3.578004,
      0,
      3,
      NULL,
      NULL,
      NULL,
      0,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.319777,
      NULL,
      1,
      2,
      0.466934,
      NULL,
      NULL,
      0,
      2,
      0,
      0,
      0.731127,
      1,
      1.787391,
      0.219938,
      1,
      1.014698,
      1,
      1.628058,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      '21301',
      NULL,
      '',
      1.799731,
      '',
      '',
      '',
      5,
      '3212',
      NULL,
      '',
      3,
      2,
      NULL,
      2,
      NULL,
      3.882059,
      3.924273,
      1,
      3);
commit;
end;
/


