set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9856715';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-7-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1404',
      '24310444',
      50.716254,
      86,
      '4300022',
      66.099258,
      3,
      1.104995,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      1.925563,
      NULL,
      1,
      NULL,
      1,
      0.857645,
      NULL,
      2,
      1,
      0,
      NULL,
      0.890606,
      0.318525,
      0,
      1.898969,
      1.557712,
      NULL,
      3.025612,
      1.484697,
      1.111762,
      5,
      1.758366,
      NULL,
      NULL,
      4,
      0,
      0,
      NULL,
      NULL,
      1.378343,
      NULL,
      NULL,
      0.130379,
      NULL,
      NULL,
      0,
      4,
      2,
      1,
      NULL,
      0.116313,
      2.350461,
      1,
      0,
      3.881040,
      NULL,
      2,
      2.426037,
      2.752537,
      0,
      2.472443,
      0.667583,
      1,
      0,
      0.909266,
      3.155809,
      5,
      5,
      0,
      1,
      NULL,
      1.563755,
      NULL,
      NULL,
      0.602107,
      NULL,
      NULL,
      1,
      2,
      0,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0,
      0,
      1.281171,
      1.926762,
      1.886274,
      0,
      1,
      1.302955,
      0.157713,
      NULL,
      1.580044,
      NULL,
      1,
      NULL,
      1,
      1.596506,
      0,
      0,
      0.491891,
      0,
      3,
      4,
      1,
      0,
      0,
      1.133526,
      3.193687,
      1,
      0.044534,
      NULL,
      0.819877,
      2,
      2.587857,
      2.254531,
      4,
      NULL,
      1,
      3.263540,
      0,
      1.570414,
      1,
      0,
      0,
      9.063724,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.377363,
      0,
      0,
      NULL,
      0.658204,
      1,
      0.842625,
      1.271618,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.104429,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.388766,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.764939,
      0.656396,
      3,
      0.712368,
      NULL,
      0,
      0,
      NULL,
      0.091606,
      NULL,
      0.581111,
      1,
      NULL,
      1,
      0,
      1,
      1,
      0.447913,
      1,
      1.844446,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '10301',
      '',
      NULL,
      1,
      NULL,
      '',
      '',
      0.897929,
      '3243',
      '2401',
      '',
      3,
      0.875517,
      7,
      0,
      2.911421,
      3.802588,
      NULL,
      1,
      2.521605);
commit;
end;
/


