set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-3-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '2',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      '024343',
      NULL,
      ' 2-24-2000',
      45,
      NULL,
      0,
      NULL,
      2.491971,
      0,
      0,
      NULL,
      1.074313,
      1,
      0.423306,
      0,
      1.923286,
      0,
      0,
      0.619591,
      NULL,
      6.291975,
      0,
      NULL,
      NULL,
      1.864672,
      3.367427,
      0.533763,
      1,
      1,
      NULL,
      1,
      NULL,
      0.151272,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.330859,
      3,
      1.144273,
      3.738002,
      NULL,
      1.332929,
      1,
      1.255830,
      3,
      0,
      1.319859,
      0.868629,
      0.706544,
      1.450262,
      1.378466,
      1,
      NULL,
      NULL,
      1.297657,
      0,
      1,
      1,
      1.862208,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      0.178399,
      NULL,
      NULL,
      1.353856,
      1.024404,
      2,
      NULL,
      1,
      0.454440,
      1,
      0.409666,
      0,
      NULL,
      NULL,
      0.550708,
      1.495648,
      1,
      1.872437,
      0.578963,
      0,
      1,
      0,
      NULL,
      1,
      0,
      3.762195,
      NULL,
      0,
      0,
      1,
      1.798542,
      1,
      1.116111,
      0,
      1,
      0,
      0,
      1.178303,
      0,
      0.778432,
      5.436697,
      1,
      NULL,
      0.211664,
      NULL,
      NULL,
      4,
      3.158842,
      1.344906,
      NULL,
      1.599144,
      NULL,
      0.600633,
      0,
      9.391838,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.946693,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.694421,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.821361,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.295038,
      NULL,
      NULL,
      NULL,
      NULL,
      0.827861,
      0,
      NULL,
      1.873421,
      1.246786,
      2,
      1.439488,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.016482,
      NULL,
      0,
      0,
      NULL,
      0,
      1.738658,
      0.399903,
      0.896964,
      0,
      1,
      0.380882,
      1.938418,
      0.615613,
      0.481963,
      0,
      1.545354,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.523381,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '40010',
      '32002',
      NULL,
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


