set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-4-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '1',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.922384,
      2,
      '204111',
      0.029597,
      ' 8-25-1997',
      NULL,
      NULL,
      1,
      NULL,
      1.139981,
      0.468732,
      0.995126,
      1,
      1,
      1.015098,
      0.560144,
      1,
      1,
      NULL,
      2,
      1,
      0.135417,
      NULL,
      0.153456,
      1.205618,
      0,
      NULL,
      4,
      3.896491,
      1.132735,
      0.254716,
      NULL,
      NULL,
      NULL,
      1.009202,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.237971,
      4.277755,
      2,
      0.925939,
      0.867880,
      2.937430,
      2,
      3,
      NULL,
      0.311168,
      NULL,
      1,
      1.549120,
      1.489244,
      1,
      3.839087,
      1.150833,
      1.926432,
      NULL,
      0.946826,
      1.915544,
      NULL,
      0,
      NULL,
      NULL,
      1.028050,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.742541,
      1,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      1.641893,
      NULL,
      NULL,
      0,
      0,
      1.912160,
      1.606695,
      1.392899,
      0.329063,
      3.661417,
      1.323340,
      1.201038,
      1.815126,
      1.247483,
      NULL,
      0.470519,
      0.393295,
      NULL,
      NULL,
      NULL,
      5.806918,
      NULL,
      3.871964,
      5.873565,
      1.283094,
      3.302820,
      7,
      3,
      1,
      6.802404,
      5.385567,
      3,
      NULL,
      NULL,
      1,
      0.984759,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.012060,
      0,
      0,
      1,
      0,
      1.005930,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.783045,
      NULL,
      NULL,
      1,
      0.961843,
      1,
      NULL,
      1.566207,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2.062655,
      1,
      NULL,
      NULL,
      0.273632,
      1,
      1.571095,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.574664,
      1,
      2.993980,
      NULL,
      0.574979,
      NULL,
      0,
      0.506821,
      NULL,
      0,
      0.077389,
      1.118813,
      1,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.464130,
      0.331448,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.779148,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.361699,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.041543,
      1.661992,
      1.111609,
      NULL,
      0.691288,
      0.310877,
      0,
      0,
      7.567549,
      '11400',
      '41144',
      '43100',
      NULL,
      '',
      '',
      '',
      1,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


