set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-6-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      NULL,
      NULL,
      NULL,
      '2210242',
      5,
      5,
      NULL,
      2,
      NULL,
      0.535524,
      '10-25-1987',
      42.329246,
      NULL,
      1,
      NULL,
      1.291520,
      3.318972,
      1.635334,
      0.549706,
      1.464838,
      1.929407,
      1.202730,
      NULL,
      NULL,
      NULL,
      5,
      1.944075,
      0.758227,
      6.265322,
      0.683376,
      1,
      5.551242,
      0.143453,
      7.948369,
      NULL,
      1.930632,
      1,
      5.477216,
      1,
      0.785333,
      2.285565,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      2,
      2,
      1,
      NULL,
      1.562971,
      2,
      2,
      3,
      NULL,
      1,
      1.587087,
      0,
      0,
      0.213084,
      NULL,
      3,
      1,
      1,
      NULL,
      1.471553,
      0,
      NULL,
      NULL,
      2,
      3.340792,
      NULL,
      NULL,
      NULL,
      1.784187,
      NULL,
      NULL,
      NULL,
      1.362069,
      3.383929,
      0,
      3,
      1,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      0.544682,
      1.891830,
      1,
      1,
      0.269918,
      NULL,
      1.965012,
      NULL,
      1.565813,
      0,
      NULL,
      1.972911,
      0.593397,
      1.992541,
      0,
      1.847514,
      NULL,
      3.752508,
      1.667113,
      0,
      1,
      0,
      NULL,
      1.253193,
      1,
      0,
      0,
      4,
      6.871966,
      1,
      NULL,
      1,
      0.258071,
      0,
      0,
      2.393706,
      NULL,
      1,
      1.795380,
      9,
      0.536200,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.059673,
      1.410299,
      NULL,
      0.325918,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.088376,
      3.587739,
      0,
      1,
      1.173808,
      1,
      1.273692,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      4.445335,
      1.767811,
      3,
      1,
      1.537228,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.357204,
      5.056212,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.357091,
      NULL,
      1.873520,
      NULL,
      NULL,
      1.364978,
      1.803363,
      1.678328,
      2,
      NULL,
      NULL,
      1.072858,
      0,
      1.390289,
      0,
      0.825673,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.639029,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.668523,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.342854,
      NULL,
      0,
      NULL,
      0.705375,
      NULL,
      0.246472,
      NULL,
      0,
      NULL,
      '33222',
      '34032',
      NULL,
      NULL,
      '',
      '',
      0.138036,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


