set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-10-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '1',
      NULL,
      NULL,
      '0430330',
      21,
      5,
      0,
      NULL,
      '202224',
      0.578584,
      ' 0-10-1979',
      12.649826,
      NULL,
      0.715534,
      NULL,
      1,
      0.953063,
      0,
      1.956244,
      NULL,
      1,
      1,
      1.152919,
      0,
      0.081109,
      1.464293,
      0,
      NULL,
      4,
      1.085511,
      0,
      7,
      1,
      1.586147,
      7,
      0,
      1,
      5.082085,
      0,
      1.262737,
      3,
      0.850118,
      1.119317,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.168622,
      0,
      NULL,
      1,
      0,
      0.547439,
      1.601304,
      1.329797,
      NULL,
      0,
      1,
      3.760023,
      1,
      0,
      1,
      NULL,
      1,
      0,
      1,
      1.078975,
      1,
      4,
      0,
      0,
      NULL,
      0.132500,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      1.871365,
      0,
      0,
      1.856766,
      NULL,
      0.546984,
      1.074592,
      0.529356,
      0.908190,
      0,
      0,
      1.385733,
      0,
      0.453634,
      1.697581,
      1,
      NULL,
      0.428436,
      NULL,
      0.589514,
      5,
      4,
      1.001085,
      NULL,
      0.791003,
      5,
      0,
      1,
      0,
      2.536377,
      NULL,
      4,
      2.709801,
      2,
      3,
      NULL,
      7.578716,
      3,
      1.514436,
      1.942838,
      3,
      9,
      2.148731,
      19,
      0,
      NULL,
      1,
      NULL,
      5.259110,
      0.054088,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.515437,
      NULL,
      0,
      1,
      0.939576,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      3.405688,
      0,
      NULL,
      NULL,
      NULL,
      0.673997,
      NULL,
      3.167608,
      1.693609,
      0.624078,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.263730,
      3.958455,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.077809,
      NULL,
      1.338332,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      2.155596,
      0,
      0.623911,
      NULL,
      1.525121,
      1.677416,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '40413',
      '04412',
      '',
      0.723174,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


