set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-10-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '0',
      NULL,
      NULL,
      NULL,
      7,
      1,
      0,
      1,
      '233300',
      3.015926,
      ' 7-16-1982',
      NULL,
      NULL,
      1.916975,
      NULL,
      3,
      1,
      1,
      1.084758,
      0.231070,
      1.315462,
      NULL,
      1.472586,
      0,
      NULL,
      5.935790,
      0,
      3,
      1.592103,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      8.357409,
      0,
      2.087598,
      0.116482,
      4,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      11,
      3,
      4,
      2.728392,
      0.165864,
      1,
      0,
      0,
      0,
      0,
      2,
      2,
      NULL,
      2,
      2.293606,
      0.106668,
      3.865369,
      0,
      NULL,
      4.574008,
      1.926711,
      4,
      8,
      NULL,
      2,
      5.442781,
      NULL,
      NULL,
      NULL,
      0.069797,
      NULL,
      NULL,
      0,
      1,
      0.814154,
      NULL,
      1.582705,
      NULL,
      1.751716,
      NULL,
      0.323466,
      0,
      NULL,
      NULL,
      0.736692,
      0,
      1.381390,
      1,
      0,
      0.178393,
      NULL,
      NULL,
      NULL,
      1,
      1.778961,
      NULL,
      4.074071,
      0.772834,
      0,
      1,
      3.284161,
      NULL,
      1,
      NULL,
      NULL,
      1,
      4.576024,
      1,
      0.072321,
      7.696568,
      2.246261,
      4.356693,
      2,
      1,
      3.995483,
      0,
      0,
      3.252558,
      4.673877,
      NULL,
      0.508648,
      0,
      NULL,
      1.525354,
      1.037083,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      0.839373,
      0.407509,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.546013,
      NULL,
      NULL,
      0.164990,
      1.220462,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.458563,
      3,
      1.959468,
      NULL,
      NULL,
      NULL,
      4.635287,
      1.401465,
      2.907273,
      1,
      1.247953,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.397764,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1.922809,
      1.047816,
      0.210311,
      2,
      1,
      0,
      0,
      1,
      0.660221,
      1.060484,
      0.466369,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      '40141',
      '03043',
      1.492102,
      NULL,
      NULL,
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


