set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-3-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '0',
      NULL,
      NULL,
      '4214143',
      6.225300,
      3,
      1.388085,
      2,
      '124334',
      0,
      ' 6-20-1978',
      47.478358,
      NULL,
      1.137390,
      NULL,
      NULL,
      1.729895,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      0.085215,
      2.156020,
      NULL,
      NULL,
      NULL,
      0.163355,
      1,
      1.407788,
      0,
      8,
      NULL,
      0,
      1.801661,
      0.706894,
      NULL,
      1,
      0.866711,
      1.965917,
      0.723190,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0,
      1.335123,
      1.375423,
      0.726510,
      1,
      2,
      0.543377,
      3.553370,
      1.855398,
      3.465548,
      1.070082,
      2,
      0,
      NULL,
      1.752624,
      3.346299,
      0,
      0,
      3.980981,
      0.235321,
      8,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.566722,
      0,
      0,
      1,
      NULL,
      0,
      1.769370,
      1,
      1.929023,
      0,
      0.985639,
      0,
      0,
      1.609062,
      1,
      NULL,
      0,
      1.584947,
      NULL,
      0.318194,
      3.134136,
      NULL,
      1,
      1.746520,
      0,
      4.928892,
      1,
      2,
      0.761665,
      1,
      4.831188,
      1,
      1.764003,
      1,
      0,
      0,
      4.533525,
      7,
      6.327396,
      6,
      1.245222,
      0.606467,
      NULL,
      3,
      1,
      3,
      4.780097,
      0,
      0,
      0,
      9,
      1.756018,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      0.100425,
      1.838010,
      0,
      1.303196,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.529527,
      1,
      NULL,
      NULL,
      0,
      0.579541,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.823182,
      1.296115,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.441434,
      NULL,
      1.708005,
      2,
      3.999622,
      1,
      NULL,
      NULL,
      1.127260,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.574238,
      2,
      2.743685,
      0,
      1,
      3,
      0.436486,
      2.888070,
      NULL,
      1,
      0.592982,
      NULL,
      0,
      1.256009,
      NULL,
      1,
      0.966316,
      0.042351,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.884317,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.498592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.962632,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.209515,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      '33141',
      '22134',
      '01332',
      NULL,
      '',
      '',
      NULL,
      0.019057,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


