set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-5-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '4',
      NULL,
      NULL,
      '2100111',
      16.228441,
      NULL,
      3,
      2,
      '113102',
      2.089682,
      '11-12-1994',
      43,
      NULL,
      1.183647,
      NULL,
      NULL,
      1.119520,
      1,
      1.930654,
      2,
      0,
      0.633234,
      0,
      0,
      0.349713,
      0,
      NULL,
      1,
      1.036405,
      NULL,
      NULL,
      9,
      NULL,
      7.002324,
      NULL,
      0,
      1.346253,
      9,
      NULL,
      3.852969,
      1,
      2.862187,
      1.268214,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.651248,
      5.232021,
      NULL,
      2.272571,
      1.307941,
      0.031189,
      1,
      1,
      NULL,
      1,
      2.889174,
      NULL,
      1.731519,
      0,
      1,
      NULL,
      3.926415,
      0,
      1,
      0,
      0.837866,
      NULL,
      3.331845,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.032865,
      NULL,
      NULL,
      1.623324,
      0,
      1.919161,
      1.385116,
      NULL,
      NULL,
      1,
      0.552976,
      0,
      0,
      0.406206,
      1,
      0,
      1.243540,
      NULL,
      0.767821,
      1,
      NULL,
      1.885215,
      NULL,
      0.641787,
      0,
      1.327386,
      1,
      1.782403,
      0.650365,
      0,
      1.335347,
      1,
      4,
      5.381034,
      0,
      1.417619,
      NULL,
      NULL,
      0.511419,
      0.727351,
      8.248500,
      6.030289,
      6,
      NULL,
      1.767436,
      0.373367,
      0,
      3,
      1,
      NULL,
      1.444535,
      NULL,
      0.380971,
      0,
      NULL,
      0.758769,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1.430047,
      0.231116,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.778820,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.531286,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.700726,
      2.473328,
      0.377255,
      0.146009,
      0,
      0.444080,
      NULL,
      NULL,
      NULL,
      0,
      0.364998,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.112949,
      1.865908,
      NULL,
      NULL,
      0.045714,
      3,
      1.336460,
      3,
      0,
      1.214634,
      1,
      1.431425,
      1,
      0.998890,
      0,
      0.341649,
      1.916197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '22304',
      '',
      '',
      0.223122,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


