set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-8-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '1',
      NULL,
      NULL,
      '1143443',
      NULL,
      6,
      2.037467,
      1,
      '334232',
      3.968461,
      ' 9-26-1979',
      47.749649,
      NULL,
      0,
      NULL,
      2,
      0,
      NULL,
      0,
      3.036004,
      0,
      0.147584,
      1.844446,
      1,
      1.699863,
      7.807731,
      NULL,
      1,
      NULL,
      1.199170,
      3.242820,
      5.940352,
      1,
      0.653804,
      7.914599,
      NULL,
      NULL,
      1.572792,
      0,
      2,
      1,
      0,
      1,
      NULL,
      NULL,
      0.280094,
      NULL,
      NULL,
      11.215987,
      5,
      1,
      NULL,
      0.613676,
      1,
      1,
      1,
      2.279434,
      2.191791,
      0,
      1.431360,
      3.995151,
      2.678576,
      NULL,
      0.397938,
      2.349622,
      1,
      NULL,
      2,
      NULL,
      4.825843,
      3.542090,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.812321,
      1.766926,
      NULL,
      0.939118,
      NULL,
      0,
      1.544593,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      0.298720,
      0.868514,
      0.736001,
      1.555352,
      NULL,
      0,
      0.622093,
      1.260789,
      1.765839,
      NULL,
      0.060169,
      4.047833,
      NULL,
      NULL,
      3.864681,
      0,
      4.136668,
      0.159008,
      NULL,
      4.731011,
      1.378720,
      0,
      5.653342,
      NULL,
      6,
      2,
      0,
      1.718143,
      2,
      7.623316,
      1.034251,
      8.088868,
      5,
      1,
      1.580873,
      0.239602,
      1.274810,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      1.665539,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.662098,
      NULL,
      1,
      NULL,
      0.286273,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.400242,
      0.459802,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      4,
      4.401690,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.679714,
      3,
      2.523087,
      2.239366,
      2,
      0,
      1,
      0.558830,
      3,
      0,
      1,
      1,
      1,
      1.447442,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.547275,
      1.051629,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.469402,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.995531,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.421978,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.008870,
      NULL,
      NULL,
      0.668053,
      0.392761,
      0,
      1,
      NULL,
      '14222',
      NULL,
      '14122',
      NULL,
      '',
      '',
      '',
      1.155112,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


