set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-9-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      8.316466,
      0,
      0.567111,
      2,
      '401223',
      1.073061,
      ' 2-19-1977',
      52,
      NULL,
      1.343824,
      NULL,
      1,
      1.480855,
      1.319621,
      0.772229,
      NULL,
      0.894279,
      1,
      0.751999,
      NULL,
      1.383186,
      0.835481,
      0.105104,
      NULL,
      0.042506,
      0,
      0,
      2.711259,
      1,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.047305,
      1.698588,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      2.684228,
      1,
      NULL,
      3,
      0.414003,
      1.328646,
      3.146381,
      1,
      NULL,
      3.149663,
      3,
      0,
      NULL,
      1,
      1,
      0.496015,
      4.667825,
      0.208740,
      6.489293,
      0.231523,
      1,
      0,
      2,
      1,
      NULL,
      NULL,
      0.022693,
      NULL,
      NULL,
      1.727998,
      0.309374,
      1.469313,
      0,
      1.421272,
      NULL,
      NULL,
      1.762298,
      NULL,
      1.342366,
      0,
      NULL,
      NULL,
      0.585434,
      1,
      1,
      1.594369,
      1.443378,
      1,
      NULL,
      1.312873,
      1.255584,
      1.654835,
      1.030570,
      NULL,
      0.639005,
      1.729063,
      0,
      0,
      0.995932,
      0.059973,
      0,
      0,
      NULL,
      0.355997,
      0,
      1.366606,
      3.024471,
      2.890592,
      6,
      0,
      NULL,
      4,
      4,
      1,
      1,
      6,
      1,
      0.573476,
      1,
      1,
      0.319151,
      1.969523,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.658483,
      0.839876,
      0,
      0,
      NULL,
      NULL,
      1.525626,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.214030,
      1.653760,
      0.175369,
      0.258773,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.831940,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      6.866180,
      1,
      4,
      1.206105,
      NULL,
      NULL,
      0.039410,
      1,
      1.551523,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.589705,
      3.782766,
      1.250251,
      3.343961,
      1,
      1.715229,
      1,
      NULL,
      1,
      NULL,
      0,
      0,
      1.788008,
      0.587930,
      0,
      1.182545,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.788463,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      7,
      '44432',
      '34224',
      '33330',
      0.334543,
      '',
      '',
      '',
      0.218726,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


