set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-10-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '2',
      NULL,
      NULL,
      '0312044',
      13.225746,
      2,
      3,
      2,
      '122310',
      NULL,
      ' 2-10-1996',
      46,
      NULL,
      NULL,
      NULL,
      NULL,
      2.074572,
      NULL,
      0,
      0.469836,
      NULL,
      2.511100,
      NULL,
      1.789771,
      0.689960,
      7.217607,
      0,
      NULL,
      5,
      1,
      0.610904,
      1,
      0.554385,
      2.149425,
      3,
      NULL,
      1.585863,
      NULL,
      0,
      5.902424,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.201778,
      NULL,
      NULL,
      0,
      1.484852,
      NULL,
      2.239615,
      0.268768,
      0.728765,
      1,
      2,
      3.219961,
      3.990920,
      NULL,
      1.818767,
      3.311706,
      2,
      0,
      2,
      NULL,
      0.927540,
      0,
      NULL,
      NULL,
      NULL,
      7,
      0,
      1,
      1.620099,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.200180,
      0.427211,
      1,
      0,
      1.130887,
      NULL,
      0,
      0,
      1,
      0,
      0.702507,
      0,
      0.131531,
      NULL,
      1,
      1.500179,
      1,
      NULL,
      0,
      NULL,
      1,
      0.851371,
      1,
      0,
      NULL,
      NULL,
      1.248797,
      1.782268,
      1.925313,
      0,
      1,
      1,
      0.997086,
      1,
      0.266990,
      0,
      0.838802,
      7,
      5.966185,
      7.161428,
      9.688360,
      NULL,
      5,
      0,
      0.352141,
      0,
      1.050977,
      2,
      2,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      1,
      0.523357,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.226644,
      NULL,
      6,
      1,
      1,
      0.540950,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      4.861162,
      1.604267,
      0.907008,
      0,
      5,
      0,
      1.070730,
      0.760436,
      NULL,
      NULL,
      1.398959,
      1,
      0.980162,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.943529,
      2,
      2.562529,
      3,
      NULL,
      1,
      0.456008,
      NULL,
      1.107448,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.761412,
      NULL,
      1.107413,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '31211',
      '30411',
      '34030',
      1,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


