set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-3-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '0',
      NULL,
      NULL,
      '4133140',
      NULL,
      5,
      1,
      NULL,
      NULL,
      2.787205,
      ' 0-24-1999',
      36.750336,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.547364,
      2.633698,
      0.007977,
      1.184952,
      0,
      2,
      0,
      1.265336,
      7.625443,
      2.563300,
      NULL,
      6.749090,
      3,
      NULL,
      NULL,
      3,
      1.813003,
      5,
      1,
      NULL,
      3.172768,
      1,
      1.326318,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.284261,
      NULL,
      0.974323,
      0.154929,
      NULL,
      3.120846,
      2,
      3.612033,
      1,
      NULL,
      1.804453,
      0,
      2.843112,
      0.564667,
      0,
      NULL,
      3.522734,
      1,
      NULL,
      1,
      0,
      7.695758,
      9.567036,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.342187,
      NULL,
      NULL,
      0,
      1,
      4,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1.534562,
      1.781780,
      1.164430,
      0.429921,
      1.572135,
      0.101989,
      NULL,
      1.845681,
      0.073006,
      1,
      NULL,
      1,
      5.530444,
      NULL,
      1,
      3,
      0.362264,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      1,
      0.664159,
      2,
      0,
      0,
      NULL,
      8,
      2.625419,
      5.012128,
      1.185468,
      1.082204,
      4.978996,
      4,
      5,
      2.245308,
      3.391504,
      2,
      0,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.716241,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.827587,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      4.875487,
      3.117996,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      0.229210,
      1.310815,
      1,
      NULL,
      1,
      0.327545,
      8.357168,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.380177,
      NULL,
      2.115589,
      2,
      2.812406,
      3.295359,
      1,
      2.372168,
      1.366933,
      1,
      NULL,
      0,
      0,
      1,
      1.826412,
      1,
      1.304916,
      1,
      1,
      1.831496,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '10314',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


