set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-8-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      '2140130',
      46.602866,
      0,
      2.445794,
      1,
      '031202',
      2,
      ' 3-11-1983',
      46,
      NULL,
      0,
      NULL,
      1.927347,
      2.720709,
      0.279471,
      1.163258,
      0,
      3,
      NULL,
      1.779017,
      0.258913,
      NULL,
      5.110724,
      1.932668,
      1.292918,
      0.455327,
      0.179193,
      1.879421,
      NULL,
      NULL,
      5,
      0.872435,
      NULL,
      0,
      2,
      1,
      2.114477,
      0.606531,
      1,
      1,
      NULL,
      NULL,
      0.653766,
      NULL,
      NULL,
      NULL,
      0.613728,
      4,
      1.594961,
      3,
      0.231785,
      3,
      0.171281,
      1.723270,
      NULL,
      0,
      0,
      NULL,
      2,
      2.204651,
      1,
      1,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1.802004,
      0,
      0,
      0.888843,
      NULL,
      NULL,
      NULL,
      1.850762,
      NULL,
      NULL,
      1.971158,
      0.036073,
      1.990909,
      NULL,
      0.366264,
      NULL,
      1,
      1,
      0.243447,
      1,
      NULL,
      NULL,
      0,
      1.534195,
      1,
      1.112710,
      1.364193,
      1.037414,
      1,
      NULL,
      1.640241,
      0.813580,
      1,
      0,
      NULL,
      0.977007,
      1.302138,
      1.525015,
      1.250887,
      NULL,
      1.861710,
      0.216314,
      NULL,
      0.823705,
      0,
      1.448495,
      0,
      4,
      4,
      4,
      NULL,
      3.563572,
      3,
      2,
      4,
      1.078464,
      5,
      4.051836,
      2.490206,
      0.573789,
      0,
      0.965650,
      0.146635,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.641021,
      0.120984,
      NULL,
      0,
      1.753403,
      0.180275,
      1,
      1.778991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.756059,
      2.389491,
      NULL,
      7.477881,
      1.633284,
      0,
      1,
      NULL,
      2.196875,
      10,
      1.583058,
      0.257976,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      4,
      4,
      NULL,
      NULL,
      1.866944,
      NULL,
      NULL,
      NULL,
      0.802986,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.396209,
      NULL,
      2.107354,
      1.682502,
      0,
      1.185950,
      0.102029,
      0.178537,
      0.012429,
      0,
      NULL,
      0.163129,
      NULL,
      NULL,
      0.482965,
      0.975461,
      1,
      1.670622,
      0.571188,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.421312,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.544459,
      '32412',
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      '',
      0,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


