set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-3-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      NULL,
      NULL,
      NULL,
      '0432134',
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      '10-14-1985',
      10,
      NULL,
      1.399363,
      NULL,
      0.918743,
      0.876512,
      0,
      1,
      NULL,
      NULL,
      3.346717,
      0.523796,
      0,
      1.615696,
      0.768652,
      1,
      NULL,
      NULL,
      1.724369,
      NULL,
      9,
      1.291953,
      1,
      4,
      1,
      0,
      6,
      0,
      2,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.688937,
      1.892511,
      3,
      1,
      1.167455,
      0.184579,
      0.771436,
      1.512877,
      2.302084,
      NULL,
      0,
      2,
      3.680057,
      0.545887,
      0,
      1.904629,
      0,
      0.968639,
      NULL,
      NULL,
      5.402802,
      0.318186,
      NULL,
      0,
      3.254943,
      0,
      NULL,
      NULL,
      0.979889,
      NULL,
      NULL,
      1,
      1.082872,
      1.480102,
      0,
      1,
      1,
      NULL,
      1.108738,
      1,
      1,
      NULL,
      0.236958,
      1.798679,
      NULL,
      0,
      1,
      1,
      1.372646,
      1.805356,
      NULL,
      0.457017,
      NULL,
      1,
      1,
      NULL,
      1.580163,
      0,
      0,
      NULL,
      0.040866,
      0.848836,
      3.455149,
      1.090733,
      1.301224,
      2,
      0.754051,
      1.201700,
      6,
      5.082355,
      5.410024,
      NULL,
      5.730425,
      0,
      3,
      5,
      0,
      1,
      NULL,
      2.020116,
      0.637682,
      0,
      2.596714,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      1.132174,
      1,
      1.475740,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0,
      NULL,
      0.649255,
      0.163697,
      NULL,
      0.145849,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.429120,
      2.304206,
      0,
      1,
      0.291703,
      NULL,
      NULL,
      NULL,
      0.421677,
      6,
      1.077307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.087530,
      1,
      1.338600,
      0.308132,
      1,
      0,
      0.252688,
      0,
      0.518871,
      NULL,
      1,
      1.698354,
      0,
      1.385748,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.576509,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '04140',
      NULL,
      NULL,
      1.315733,
      NULL,
      '',
      '',
      0.490545,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


