set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-8-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '0',
      NULL,
      NULL,
      '0041222',
      80,
      5,
      0.172032,
      2,
      '132142',
      2.451835,
      ' 7- 3-1975',
      43,
      NULL,
      0,
      NULL,
      1.342014,
      1.575621,
      1.431662,
      NULL,
      0.420258,
      0,
      3.532048,
      NULL,
      1.500617,
      0.843688,
      2,
      NULL,
      1.528463,
      NULL,
      0.405121,
      NULL,
      1.855222,
      0.857761,
      4,
      NULL,
      1.414512,
      NULL,
      5.831604,
      1,
      3,
      0.801960,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.897420,
      1,
      0.701466,
      3.163476,
      2,
      2.248967,
      2,
      0.908166,
      NULL,
      0,
      1.494206,
      1.771633,
      0,
      0,
      3.574451,
      NULL,
      1,
      1,
      3.367921,
      NULL,
      1.085985,
      7,
      0,
      1,
      0,
      1,
      1.527140,
      NULL,
      NULL,
      1.781063,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      1,
      0.882220,
      0.521594,
      0.576284,
      1,
      0.047429,
      1.567983,
      NULL,
      0,
      1,
      0.584238,
      1,
      0,
      NULL,
      NULL,
      0,
      2.574483,
      0.766588,
      NULL,
      0,
      1.145631,
      1,
      NULL,
      NULL,
      NULL,
      1.447766,
      0,
      1.355611,
      0.229743,
      5,
      0,
      3.571541,
      3.237507,
      0,
      NULL,
      NULL,
      7.670473,
      3,
      0,
      3.212951,
      5.081798,
      6,
      4.253952,
      2.337016,
      1.710343,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      0.238508,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.446528,
      NULL,
      NULL,
      NULL,
      NULL,
      1.569329,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.628808,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.132799,
      1,
      4.076785,
      5,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      1.831147,
      0,
      0.855327,
      0.418104,
      NULL,
      1.127364,
      0.950848,
      1,
      0.945408,
      NULL,
      1,
      1,
      NULL,
      0.715599,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.745276,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.908430,
      '40430',
      NULL,
      '',
      0.617576,
      '',
      '',
      '',
      1.822435,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


