set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-2-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      '0314113',
      14,
      2,
      2,
      0,
      '331224',
      3.280991,
      ' 0- 4-1993',
      56.730953,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.699214,
      NULL,
      NULL,
      1.634785,
      1.039305,
      1.264916,
      3,
      NULL,
      1,
      0,
      0,
      NULL,
      0.496020,
      0.229927,
      0,
      3,
      1,
      1.398909,
      6.937119,
      1,
      4,
      1.715979,
      0,
      NULL,
      NULL,
      NULL,
      0.489969,
      NULL,
      NULL,
      0.388392,
      NULL,
      0,
      3,
      0,
      NULL,
      1,
      NULL,
      3.548189,
      NULL,
      1.634758,
      1.934290,
      1.628471,
      2,
      2.394438,
      0.897862,
      3,
      NULL,
      NULL,
      3,
      3.408483,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.771217,
      NULL,
      NULL,
      0.206047,
      NULL,
      NULL,
      0,
      1.054651,
      0,
      0.895950,
      1,
      1.420635,
      0,
      1.754951,
      NULL,
      1,
      NULL,
      1.411940,
      0.611928,
      0.097632,
      0.159704,
      1.193949,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      0.971094,
      1.207632,
      2,
      0,
      4,
      1,
      NULL,
      0,
      NULL,
      0.509412,
      3,
      1.504396,
      1,
      NULL,
      6,
      NULL,
      3,
      0.341747,
      4,
      5,
      6,
      0.604673,
      1.186427,
      1.162863,
      1,
      0.638716,
      1.067211,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1.384260,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      3.442305,
      1,
      2.241441,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.740292,
      1.107967,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.994533,
      6.972001,
      4,
      4.130616,
      2,
      NULL,
      1.539680,
      NULL,
      NULL,
      0.991594,
      7.913013,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.267415,
      2.988786,
      2,
      3.963938,
      1,
      1.222475,
      0,
      2,
      0.403052,
      3,
      NULL,
      0.255666,
      1,
      0,
      0,
      0,
      NULL,
      1.028149,
      0.258475,
      0.901388,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.503897,
      '42102',
      '',
      '',
      0,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


