set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-9-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '2',
      NULL,
      NULL,
      '0304113',
      NULL,
      6,
      3,
      0,
      '334133',
      3,
      ' 2-14-1984',
      NULL,
      NULL,
      1,
      NULL,
      0,
      3,
      1,
      0.523368,
      0,
      NULL,
      NULL,
      0.908945,
      1,
      1.505746,
      1.439531,
      1,
      0.839255,
      0,
      1.387604,
      1,
      1.551570,
      1,
      2,
      0,
      0,
      0.849018,
      4.080856,
      1,
      NULL,
      0,
      2.135731,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      NULL,
      0.033611,
      3,
      3,
      0,
      1,
      NULL,
      NULL,
      1.124764,
      0,
      1,
      2.165096,
      0,
      1,
      3.844896,
      2,
      1.560921,
      NULL,
      0,
      0.882412,
      NULL,
      0.769564,
      1,
      1,
      1.833776,
      1.558663,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1.226667,
      0,
      NULL,
      1.506795,
      0.034116,
      NULL,
      0.313848,
      0,
      1.553554,
      1,
      1,
      0.824711,
      1.967445,
      0.696560,
      0,
      1,
      NULL,
      0.286021,
      5.192770,
      NULL,
      1.531189,
      1,
      0,
      3.175313,
      1.329002,
      4.703644,
      1.701012,
      1,
      1.743752,
      NULL,
      NULL,
      4.276027,
      1.045247,
      NULL,
      7,
      6.259224,
      6,
      NULL,
      2,
      2,
      6,
      5.424692,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5.896227,
      0.984021,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.448553,
      0,
      0,
      1.904508,
      1,
      1.995821,
      0.011598,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.990078,
      NULL,
      NULL,
      NULL,
      NULL,
      1.203418,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.628960,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0.649768,
      0,
      4.676557,
      4,
      0.718805,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.414466,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.245099,
      1.629465,
      0,
      2,
      2,
      1,
      NULL,
      1,
      3,
      NULL,
      NULL,
      0.639194,
      0,
      0,
      1,
      1.370105,
      0,
      0.603394,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.182504,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '23440',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


